/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadfileinput;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputField;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.YNLoadSaveValidator;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class LoadFileInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    String xmlOrig = "    <include>N</include>    <include_field/>    <rownum>N</rownum>    <addresultfile>Y</addresultfile>    <IsIgnoreEmptyFile>N</IsIgnoreEmptyFile>    <IsIgnoreMissingPath>N</IsIgnoreMissingPath>    <rownum_field/>    <encoding/>    <file>      <name>D:\\DZMITRY</name>      <filemask>*/</filemask>      <exclude_filemask>/***</exclude_filemask>      <file_required>N</file_required>      <include_subfolders>N</include_subfolders>      </file>    <fields>      </fields>    <limit>0</limit>    <IsInFields>N</IsInFields>    <DynamicFilenameField/>    <shortFileFieldName/>    <pathFieldName/>    <hiddenFieldName/>    <lastModificationTimeFieldName/>    <uriNameFieldName/>    <rootUriNameFieldName/>    <extensionFieldName/>";

    public LoadFileInputMeta createMeta() throws Exception {
        LoadFileInputMeta meta = new LoadFileInputMeta();
        meta.allocate(1, 0);
        meta.setIncludeFilename(false);
        meta.setFilenameField(null);
        meta.setAddResultFile(true);
        meta.setIgnoreEmptyFile(false);
        meta.setIncludeRowNumber(false);
        meta.setRowNumberField(null);
        meta.setEncoding(null);
        meta.setFileName(new String[]{"D:\\DZMITRY"});
        meta.setFileMask(new String[]{"*/"});
        meta.setExcludeFileMask(new String[]{"/***"});
        meta.setFileRequired(new String[]{"N"});
        meta.setIncludeSubFolders(new String[]{"N"});
        meta.setRowLimit(0L);
        meta.setIsInFields(false);
        meta.setDynamicFilenameField(null);
        meta.setShortFileNameField(null);
        meta.setPathField(null);
        meta.setIsHiddenField(null);
        meta.setLastModificationDateField(null);
        meta.setUriField(null);
        meta.setRootUriField(null);
        meta.setExtensionField(null);
        return meta;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetXML() throws Exception {
        LoadFileInputMeta testMeta = this.createMeta();
        String xml = testMeta.getXML();
        Assert.assertEquals((Object)this.xmlOrig.replaceAll("\n", "").replaceAll("\r", ""), (Object)xml.replaceAll("\n", "").replaceAll("\r", ""));
    }

    @Test
    public void testLoadXML() throws Exception {
        LoadFileInputMeta origMeta = this.createMeta();
        LoadFileInputMeta testMeta = new LoadFileInputMeta();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader("<step>" + this.xmlOrig + "</step>")));
        IMetaStore metaStore = null;
        testMeta.loadXML(doc.getFirstChild(), null, metaStore);
        Assert.assertEquals((Object)origMeta, (Object)testMeta);
    }

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("includeFilename", "filenameField", "includeRowNumber", "rowNumberField", "rowLimit", "encoding", "DynamicFilenameField", "fileinfield", "addresultfile", "IsIgnoreEmptyFile", "IsIgnoreMissingPath", "shortFileFieldName", "pathFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName", "extensionFieldName", "includeSubFolders", "fileName", "fileMask", "excludeFileMask", "fileRequired", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "getIncludeFilename");
                this.put("filenameField", "getFilenameField");
                this.put("includeRowNumber", "getIncludeRowNumber");
                this.put("rowNumberField", "getRowNumberField");
                this.put("rowLimit", "getRowLimit");
                this.put("encoding", "getEncoding");
                this.put("DynamicFilenameField", "getDynamicFilenameField");
                this.put("fileinfield", "getFileInFields");
                this.put("addresultfile", "getAddResultFile");
                this.put("IsIgnoreEmptyFile", "isIgnoreEmptyFile");
                this.put("IsIgnoreMissingPath", "isIgnoreMissingPath");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("pathFieldName", "getPathField");
                this.put("hiddenFieldName", "isHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("includeSubFolders", "getIncludeSubFolders");
                this.put("fileName", "getFileName");
                this.put("fileMask", "getFileMask");
                this.put("excludeFileMask", "getExcludeFileMask");
                this.put("fileRequired", "getFileRequired");
                this.put("inputFields", "getInputFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "setIncludeFilename");
                this.put("filenameField", "setFilenameField");
                this.put("includeRowNumber", "setIncludeRowNumber");
                this.put("rowNumberField", "setRowNumberField");
                this.put("rowLimit", "setRowLimit");
                this.put("encoding", "setEncoding");
                this.put("DynamicFilenameField", "setDynamicFilenameField");
                this.put("fileinfield", "setFileInFields");
                this.put("addresultfile", "setAddResultFile");
                this.put("IsIgnoreEmptyFile", "setIgnoreEmptyFile");
                this.put("IsIgnoreMissingPath", "setIgnoreMissingPath");
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("pathFieldName", "setPathField");
                this.put("hiddenFieldName", "setIsHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("includeSubFolders", "setIncludeSubFolders");
                this.put("fileName", "setFileName");
                this.put("fileMask", "setFileMask");
                this.put("excludeFileMask", "setExcludeFileMask");
                this.put("fileRequired", "setFileRequired");
                this.put("inputFields", "setInputFields");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<LoadFileInputField> lfifArrayLoadSaveValidator = new ArrayLoadSaveValidator<LoadFileInputField>(new LoadFileInputFieldLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<String> YNArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new YNLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", YNArrayLoadSaveValidator);
        attrValidatorMap.put("inputFields", lfifArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(LoadFileInputMeta.class, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof LoadFileInputMeta) {
            ((LoadFileInputMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class LoadFileInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<LoadFileInputField> {
        final Random rand = new Random();

        @Override
        public LoadFileInputField getTestObject() {
            LoadFileInputField rtn = new LoadFileInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setElementType(this.rand.nextInt(2));
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setType(this.rand.nextInt(5));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setLength(this.rand.nextInt(50));
            return rtn;
        }

        @Override
        public boolean validateTestObject(LoadFileInputField testObject, Object actualObj) {
            if (!(actualObj instanceof LoadFileInputField)) {
                return false;
            }
            LoadFileInputField actual = (LoadFileInputField)actualObj;
            boolean tst1 = actual.getXML().equals(testObject.getXML());
            LoadFileInputField aClone = (LoadFileInputField)testObject.clone();
            boolean tst2 = actual.getXML().equals(aClone.getXML());
            return tst1 && tst2;
        }
    }
}

