/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldifinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputField;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.YNLoadSaveValidator;

public class LDIFInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("includeFilename", "filenameField", "includeRowNumber", "rowNumberField", "rowLimit", "addtoresultfilename", "multiValuedSeparator", "includeContentType", "contentTypeField", "DNField", "includeDN", "filefield", "dynamicFilenameField", "shortFileFieldName", "pathFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName", "extensionFieldName", "sizeFieldName", "fileRequired", "includeSubFolders", "fileName", "fileMask", "excludeFileMask", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "getIncludeFilename");
                this.put("filenameField", "getFilenameField");
                this.put("includeRowNumber", "getIncludeRowNumber");
                this.put("rowNumberField", "getRowNumberField");
                this.put("rowLimit", "getRowLimit");
                this.put("addtoresultfilename", "getAddToResultFilename");
                this.put("multiValuedSeparator", "getMultiValuedSeparator");
                this.put("includeContentType", "getIncludeContentType");
                this.put("contentTypeField", "getContentTypeField");
                this.put("DNField", "getDNField");
                this.put("includeDN", "getIncludeDN");
                this.put("filefield", "isFileField");
                this.put("dynamicFilenameField", "getDynamicFilenameField");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("pathFieldName", "getPathField");
                this.put("hiddenFieldName", "getHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("sizeFieldName", "getSizeField");
                this.put("fileRequired", "getFileRequired");
                this.put("includeSubFolders", "getIncludeSubFolders");
                this.put("fileName", "getFileName");
                this.put("fileMask", "getFileMask");
                this.put("excludeFileMask", "getExcludeFileMask");
                this.put("inputFields", "getInputFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "setIncludeFilename");
                this.put("filenameField", "setFilenameField");
                this.put("includeRowNumber", "setIncludeRowNumber");
                this.put("rowNumberField", "setRowNumberField");
                this.put("rowLimit", "setRowLimit");
                this.put("addtoresultfilename", "setAddToResultFilename");
                this.put("multiValuedSeparator", "setMultiValuedSeparator");
                this.put("includeContentType", "setIncludeContentType");
                this.put("contentTypeField", "setContentTypeField");
                this.put("DNField", "setDNField");
                this.put("includeDN", "setIncludeDN");
                this.put("filefield", "setFileField");
                this.put("dynamicFilenameField", "setDynamicFilenameField");
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("pathFieldName", "setPathField");
                this.put("hiddenFieldName", "setHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("sizeFieldName", "setSizeField");
                this.put("fileRequired", "setFileRequired");
                this.put("includeSubFolders", "setIncludeSubFolders");
                this.put("fileName", "setFileName");
                this.put("fileMask", "setFileMask");
                this.put("excludeFileMask", "setExcludeFileMask");
                this.put("inputFields", "setInputFields");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<LDIFInputField> liflsv = new ArrayLoadSaveValidator<LDIFInputField>(new LDIFInputFieldLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<String> YNArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new YNLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", YNArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("inputFields", liflsv);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(LDIFInputMeta.class, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof LDIFInputMeta) {
            ((LDIFInputMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class LDIFInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<LDIFInputField> {
        final Random rand = new Random();

        @Override
        public LDIFInputField getTestObject() {
            LDIFInputField rtn = new LDIFInputField();
            rtn.setAttribut(UUID.randomUUID().toString());
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setLength(this.rand.nextInt(50));
            rtn.setName(UUID.randomUUID().toString());
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setSamples(new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()});
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setType(this.rand.nextInt(5));
            return rtn;
        }

        @Override
        public boolean validateTestObject(LDIFInputField testObject, Object actual) {
            if (!(actual instanceof LDIFInputField)) {
                return false;
            }
            LDIFInputField actualInput = (LDIFInputField)actual;
            return testObject.getXML().equals(actualInput.getXML());
        }
    }
}

