/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapoutput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.ldapoutput.LDAPOutputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class LDAPOutputMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("updateLookup", "updateStream", "update", "useAuthentication", "Host", "userName", "password", "port", "dnFieldName", "failIfNotExist", "searchBase", "multiValuedSeparator", "operationType", "oldDnFieldName", "newDnFieldName", "deleteRDN");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("updateLookup", "getUpdateLookup");
                this.put("updateStream", "getUpdateStream");
                this.put("update", "getUpdate");
                this.put("useAuthentication", "getUseAuthentication");
                this.put("Host", "getHost");
                this.put("userName", "getUserName");
                this.put("password", "getPassword");
                this.put("port", "getPort");
                this.put("dnFieldName", "getDnField");
                this.put("failIfNotExist", "isFailIfNotExist");
                this.put("searchBase", "getSearchBaseDN");
                this.put("multiValuedSeparator", "getMultiValuedSeparator");
                this.put("operationType", "getOperationType");
                this.put("oldDnFieldName", "getOldDnFieldName");
                this.put("newDnFieldName", "getNewDnFieldName");
                this.put("deleteRDN", "isDeleteRDN");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("updateLookup", "setUpdateLookup");
                this.put("updateStream", "setUpdateStream");
                this.put("update", "setUpdate");
                this.put("useAuthentication", "setUseAuthentication");
                this.put("Host", "setHost");
                this.put("userName", "setUserName");
                this.put("password", "setPassword");
                this.put("port", "setPort");
                this.put("dnFieldName", "setDnField");
                this.put("failIfNotExist", "setFailIfNotExist");
                this.put("searchBase", "setSearchBaseDN");
                this.put("multiValuedSeparator", "setMultiValuedSeparator");
                this.put("operationType", "setOperationType");
                this.put("oldDnFieldName", "setOldDnFieldName");
                this.put("newDnFieldName", "setNewDnFieldName");
                this.put("deleteRDN", "setDeleteRDN");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 3);
        ArrayLoadSaveValidator<Boolean> booleanArrayLoadSaveValidator = new ArrayLoadSaveValidator<Boolean>(new BooleanLoadSaveValidator(), 3);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("update", booleanArrayLoadSaveValidator);
        attrValidatorMap.put("updateLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("updateStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("operationType", new IntLoadSaveValidator(5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<LDAPOutputMeta>(LDAPOutputMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }
}

