/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.Collections;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocolFactory;

public class LdapProtocolFactoryTest {
    @Test
    public void createLdapProtocol() throws Exception {
        String ldapVariable = "${ldap_protocol_variable}";
        String ldap = "LDAP";
        String host = "localhost";
        LdapProtocolFactory ldapProtocolFactory = new LdapProtocolFactory((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        VariableSpace variableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        LdapMeta meta = (LdapMeta)Mockito.mock(LdapMeta.class);
        ((LdapMeta)Mockito.doReturn((Object)ldapVariable).when((Object)meta)).getProtocol();
        ((VariableSpace)Mockito.doReturn((Object)ldap).when((Object)variableSpace)).environmentSubstitute(ldapVariable);
        ((LdapMeta)Mockito.doReturn((Object)host).when((Object)meta)).getHost();
        ((VariableSpace)Mockito.doReturn((Object)host).when((Object)variableSpace)).environmentSubstitute(host);
        ldapProtocolFactory.createLdapProtocol(variableSpace, meta, Collections.emptyList());
        ((VariableSpace)Mockito.verify((Object)variableSpace, (VerificationMode)Mockito.times((int)1))).environmentSubstitute(ldapVariable);
    }
}

