/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.Collection;
import javax.naming.ldap.InitialLdapContext;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocol;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocolFactory;

public class LdapMockProtocol
extends LdapProtocol {
    public static InitialLdapContext mockContext;

    public LdapMockProtocol(LogChannelInterface log, VariableSpace variableSpace, LdapMeta meta, Collection<String> binaryAttributes) {
        super(log, variableSpace, meta, binaryAttributes);
    }

    public static String getName() {
        return "LDAP MOCK";
    }

    public static InitialLdapContext setup() {
        LdapProtocolFactory.protocols.add(LdapMockProtocol.class);
        mockContext = (InitialLdapContext)Mockito.mock(InitialLdapContext.class);
        return mockContext;
    }

    public static void cleanup() {
        LdapProtocolFactory.protocols.remove(LdapMockProtocol.class);
        mockContext = null;
    }

    protected void doConnect(String username, String password) throws KettleException {
        if (mockContext == null) {
            throw new RuntimeException("LDAP Mock Connection was not setup");
        }
    }

    public InitialLdapContext getCtx() {
        if (mockContext == null) {
            throw new RuntimeException("LDAP Mock Connection was not setup");
        }
        return mockContext;
    }

    public void close() throws KettleException {
        mockContext = null;
    }
}

