/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputField;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;

public class LDAPInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<LDAPInputMeta> testMetaClass = LDAPInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("useAuthentication", "paging", "pageSize", "includeRowNumber", "rowNumberField", "rowLimit", "Host", "userName", "password", "port", "filterString", "searchBase", "timeLimit", "multiValuedSeparator", "dynamicSearch", "dynamicSearchFieldName", "dynamicFilter", "dynamicFilterFieldName", "searchScope", "protocol", "useCertificate", "trustStorePath", "trustStorePassword", "trustAllCertificates", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("useAuthentication", "UseAuthentication");
                this.put("includeRowNumber", "includeRowNumber");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("inputFields", new ArrayLoadSaveValidator<LDAPInputField>(new LDAPInputFieldLoadSaveValidator(), 5));
        attrValidatorMap.put("searchScope", new IntLoadSaveValidator(LDAPInputMeta.searchScopeCode.length));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof LDAPInputMeta) {
            ((LDAPInputMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class LDAPInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<LDAPInputField> {
        final Random rand = new Random();

        @Override
        public LDAPInputField getTestObject() {
            LDAPInputField rtn = new LDAPInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setLength(this.rand.nextInt(50));
            rtn.setType(this.rand.nextInt(7));
            rtn.setSortedKey(this.rand.nextBoolean());
            rtn.setFetchAttributeAs(this.rand.nextInt(LDAPInputField.FetchAttributeAsCode.length));
            rtn.setAttribute(UUID.randomUUID().toString());
            return rtn;
        }

        @Override
        public boolean validateTestObject(LDAPInputField testObject, Object actual) {
            if (!(actual instanceof LDAPInputField)) {
                return false;
            }
            LDAPInputField another = (LDAPInputField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append((Object)testObject.getAttribute(), (Object)another.getAttribute()).append(testObject.getReturnType(), another.getReturnType()).append(testObject.getType(), another.getType()).append(testObject.getLength(), another.getLength()).append((Object)testObject.getFormat(), (Object)another.getFormat()).append(testObject.getTrimType(), another.getTrimType()).append(testObject.getPrecision(), another.getPrecision()).append((Object)testObject.getCurrencySymbol(), (Object)another.getCurrencySymbol()).append((Object)testObject.getDecimalSymbol(), (Object)another.getDecimalSymbol()).append((Object)testObject.getGroupSymbol(), (Object)another.getGroupSymbol()).append(testObject.isRepeated(), another.isRepeated()).append(testObject.isSortedKey(), another.isSortedKey()).isEquals();
        }
    }
}

