/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.joinrows;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.joinrows.JoinRows;
import org.pentaho.di.trans.steps.joinrows.JoinRowsData;
import org.pentaho.di.trans.steps.joinrows.JoinRowsMeta;

public class JoinRowsTest {
    private StepMetaInterface meta;
    private JoinRowsData data;

    @Before
    public void setUp() throws Exception {
        this.meta = new JoinRowsMeta();
        this.data = new JoinRowsData();
    }

    @After
    public void tearDown() {
        this.meta = null;
        this.data = null;
    }

    @Test
    public void checkThatMethodPerformedWithoutError() throws Exception {
        this.getJoinRows().dispose(this.meta, (StepDataInterface)this.data);
    }

    @Test
    public void disposeDataFiles() throws Exception {
        File mockFile1 = (File)Mockito.mock(File.class);
        File mockFile2 = (File)Mockito.mock(File.class);
        this.data.file = new File[]{null, mockFile1, mockFile2};
        this.getJoinRows().dispose(this.meta, (StepDataInterface)this.data);
        ((File)Mockito.verify((Object)mockFile1, (VerificationMode)Mockito.times((int)1))).delete();
        ((File)Mockito.verify((Object)mockFile2, (VerificationMode)Mockito.times((int)1))).delete();
    }

    private JoinRows getJoinRows() throws Exception {
        StepMeta stepMeta = new StepMeta();
        TransMeta transMeta = new TransMeta();
        Trans trans = new Trans(transMeta);
        transMeta.clear();
        transMeta.addStep(stepMeta);
        transMeta.setStep(0, stepMeta);
        stepMeta.setName("test");
        trans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        trans.prepareExecution(null);
        trans.startThreads();
        return new JoinRows(stepMeta, null, 0, transMeta, trans);
    }

    @Test
    public void testJoinRowsStep() throws Exception {
        JoinRowsMeta joinRowsMeta = new JoinRowsMeta();
        joinRowsMeta.setMainStepname("main step name");
        joinRowsMeta.setPrefix("out");
        joinRowsMeta.setCacheSize(3);
        JoinRowsData joinRowsData = new JoinRowsData();
        JoinRows joinRows = this.getJoinRows();
        joinRows.getTrans().setRunning(true);
        joinRows.init((StepMetaInterface)joinRowsMeta, (StepDataInterface)joinRowsData);
        ArrayList<BlockingRowSet> rowSets = new ArrayList<BlockingRowSet>();
        rowSets.add(this.getRowSetWithData(3, "main --", true));
        rowSets.add(this.getRowSetWithData(3, "secondary --", false));
        joinRows.setInputRowSets(rowSets);
        RowStepCollector rowStepCollector = new RowStepCollector();
        joinRows.addRowListener((RowListener)rowStepCollector);
        joinRows.getLogChannel().setLogLevel(LogLevel.ROWLEVEL);
        KettleLogStore.init();
        while (joinRows.processRow((StepMetaInterface)joinRowsMeta, (StepDataInterface)joinRowsData)) {
        }
        rowStepCollector.getRowsWritten();
        Assert.assertEquals((long)9L, (long)rowStepCollector.getRowsWritten().size());
        Assert.assertEquals((long)6L, (long)rowStepCollector.getRowsRead().size());
        Object[][] expectedResult = this.createExpectedResult();
        List rowWritten = rowStepCollector.getRowsWritten().stream().map(RowMetaAndData::getData).collect(Collectors.toList());
        for (int i = 0; i < 9; ++i) {
            Assert.assertTrue((boolean)Arrays.equals(expectedResult[i], (Object[])rowWritten.get(i)));
        }
    }

    BlockingRowSet getRowSetWithData(int size, String dataPrefix, boolean isMainStep) {
        BlockingRowSet blockingRowSet = new BlockingRowSet(size);
        RowMeta rowMeta = new RowMeta();
        ValueMetaString valueMetaString = new ValueMetaString(dataPrefix + " first value name");
        ValueMetaString valueMetaInteger = new ValueMetaString(dataPrefix + " second value name");
        ValueMetaString valueMetaBoolean = new ValueMetaString(dataPrefix + " third value name");
        rowMeta.addValueMeta((ValueMetaInterface)valueMetaString);
        rowMeta.addValueMeta((ValueMetaInterface)valueMetaInteger);
        rowMeta.addValueMeta((ValueMetaInterface)valueMetaBoolean);
        blockingRowSet.setRowMeta((RowMetaInterface)rowMeta);
        for (int i = 0; i < size; ++i) {
            Object[] rowData = new Object[]{dataPrefix + " row[" + i + "]-first value", dataPrefix + " row[" + i + "]-second value", dataPrefix + " row[" + i + "]-third value"};
            blockingRowSet.putRow((RowMetaInterface)rowMeta, rowData);
        }
        if (isMainStep) {
            blockingRowSet.setThreadNameFromToCopy("main step name", 0, null, 0);
        } else {
            blockingRowSet.setThreadNameFromToCopy("secondary step name", 0, null, 0);
        }
        blockingRowSet.setDone();
        return blockingRowSet;
    }

    private Object[][] createExpectedResult() {
        Object[][] objects = new Object[][]{{"main -- row[0]-first value", "main -- row[0]-second value", "main -- row[0]-third value", "secondary -- row[0]-first value", "secondary -- row[0]-second value", "secondary -- row[0]-third value"}, {"main -- row[0]-first value", "main -- row[0]-second value", "main -- row[0]-third value", "secondary -- row[1]-first value", "secondary -- row[1]-second value", "secondary -- row[1]-third value"}, {"main -- row[0]-first value", "main -- row[0]-second value", "main -- row[0]-third value", "secondary -- row[2]-first value", "secondary -- row[2]-second value", "secondary -- row[2]-third value"}, {"main -- row[1]-first value", "main -- row[1]-second value", "main -- row[1]-third value", "secondary -- row[0]-first value", "secondary -- row[0]-second value", "secondary -- row[0]-third value"}, {"main -- row[1]-first value", "main -- row[1]-second value", "main -- row[1]-third value", "secondary -- row[1]-first value", "secondary -- row[1]-second value", "secondary -- row[1]-third value"}, {"main -- row[1]-first value", "main -- row[1]-second value", "main -- row[1]-third value", "secondary -- row[2]-first value", "secondary -- row[2]-second value", "secondary -- row[2]-third value"}, {"main -- row[2]-first value", "main -- row[2]-second value", "main -- row[2]-third value", "secondary -- row[0]-first value", "secondary -- row[0]-second value", "secondary -- row[0]-third value"}, {"main -- row[2]-first value", "main -- row[2]-second value", "main -- row[2]-third value", "secondary -- row[1]-first value", "secondary -- row[1]-second value", "secondary -- row[1]-third value"}, {"main -- row[2]-first value", "main -- row[2]-second value", "main -- row[2]-third value", "secondary -- row[2]-first value", "secondary -- row[2]-second value", "secondary -- row[2]-third value"}};
        return objects;
    }
}

