/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.joinrows;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.joinrows.JoinRowsMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ConditionLoadSaveValidator;

public class JoinRowsMetaTest {
    LoadSaveTester loadSaveTester;
    Class<JoinRowsMeta> testMetaClass = JoinRowsMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("directory", "prefix", "cacheSize", "mainStepname", "condition");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("condition", new ConditionLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<JoinRowsMeta>(this.testMetaClass, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testCleanAfterHopToRemove_NullParameter() {
        JoinRowsMeta joinRowsMeta = new JoinRowsMeta();
        StepMeta stepMeta1 = new StepMeta("Step1", (StepMetaInterface)Mockito.mock(StepMetaInterface.class));
        joinRowsMeta.setMainStep(stepMeta1);
        joinRowsMeta.setMainStepname(stepMeta1.getName());
        joinRowsMeta.cleanAfterHopToRemove(null);
        Assert.assertEquals((Object)stepMeta1, (Object)joinRowsMeta.getMainStep());
        Assert.assertEquals((String)stepMeta1.getName(), (String)joinRowsMeta.getMainStepname());
    }

    @Test
    public void testCleanAfterHopToRemove_UnknownStep() {
        JoinRowsMeta joinRowsMeta = new JoinRowsMeta();
        StepMeta stepMeta1 = new StepMeta("Step1", (StepMetaInterface)Mockito.mock(StepMetaInterface.class));
        StepMeta stepMeta2 = new StepMeta("Step2", (StepMetaInterface)Mockito.mock(StepMetaInterface.class));
        joinRowsMeta.setMainStep(stepMeta1);
        joinRowsMeta.setMainStepname(stepMeta1.getName());
        joinRowsMeta.cleanAfterHopToRemove(stepMeta2);
        Assert.assertEquals((Object)stepMeta1, (Object)joinRowsMeta.getMainStep());
        Assert.assertEquals((String)stepMeta1.getName(), (String)joinRowsMeta.getMainStepname());
    }

    @Test
    public void testCleanAfterHopToRemove_ReferredStep() {
        JoinRowsMeta joinRowsMeta = new JoinRowsMeta();
        StepMeta stepMeta1 = new StepMeta("Step1", (StepMetaInterface)Mockito.mock(StepMetaInterface.class));
        joinRowsMeta.setMainStep(stepMeta1);
        joinRowsMeta.setMainStepname(stepMeta1.getName());
        joinRowsMeta.cleanAfterHopToRemove(stepMeta1);
        Assert.assertNull((Object)joinRowsMeta.getMainStep());
        Assert.assertNull((Object)joinRowsMeta.getMainStepname());
    }
}

