/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jobexecutor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.metastore.api.IMetaStore;

public class JobExecutorMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("fileName", "jobName", "directoryPath", "groupSize", "groupField", "groupTime", "executionTimeField", "executionFilesRetrievedField", "executionLogTextField", "executionLogChannelIdField", "executionResultField", "executionNrErrorsField", "executionLinesReadField", "executionLinesWrittenField", "executionLinesInputField", "executionLinesOutputField", "executionLinesRejectedField", "executionLinesUpdatedField", "executionLinesDeletedField", "executionExitStatusField");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<JobExecutorMeta>(JobExecutorMeta.class, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testRemoveHopFrom() throws Exception {
        JobExecutorMeta jobExecutorMeta = new JobExecutorMeta();
        jobExecutorMeta.setExecutionResultTargetStepMeta(new StepMeta());
        jobExecutorMeta.setResultRowsTargetStepMeta(new StepMeta());
        jobExecutorMeta.setResultFilesTargetStepMeta(new StepMeta());
        jobExecutorMeta.cleanAfterHopFromRemove();
        Assert.assertNull((Object)jobExecutorMeta.getExecutionResultTargetStepMeta());
        Assert.assertNull((Object)jobExecutorMeta.getResultRowsTargetStepMeta());
        Assert.assertNull((Object)jobExecutorMeta.getResultFilesTargetStepMeta());
    }

    @Test
    public void testExportResources() throws KettleException {
        JobExecutorMeta jobExecutorMeta = (JobExecutorMeta)Mockito.spy((Object)new JobExecutorMeta());
        JobMeta jobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        String testName = "test";
        ((JobExecutorMeta)Mockito.doReturn((Object)jobMeta).when((Object)jobExecutorMeta)).loadJobMetaProxy((JobExecutorMeta)Mockito.any(JobExecutorMeta.class), (Repository)Mockito.any(Repository.class), (VariableSpace)Mockito.any(VariableSpace.class));
        Mockito.when((Object)jobMeta.exportResources((VariableSpace)Mockito.any(JobMeta.class), (Map)Mockito.any(Map.class), (ResourceNamingInterface)Mockito.any(ResourceNamingInterface.class), (Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class))).thenReturn((Object)testName);
        jobExecutorMeta.exportResources(null, null, null, null, null);
        ((JobMeta)Mockito.verify((Object)jobMeta)).setFilename("${Internal.Entry.Current.Directory}/" + testName);
        ((JobExecutorMeta)Mockito.verify((Object)jobExecutorMeta)).setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }

    @Test
    public void testLoadJobMeta() throws KettleException {
        String param1 = "param1";
        String param2 = "param2";
        String param3 = "param3";
        String parentValue1 = "parentValue1";
        String parentValue2 = "parentValue2";
        String childValue3 = "childValue3";
        JobExecutorMeta jobExecutorMeta = (JobExecutorMeta)Mockito.spy((Object)new JobExecutorMeta());
        Repository repository = (Repository)Mockito.mock(Repository.class);
        JobMeta meta = new JobMeta();
        meta.setVariable(param2, "childValue2 should be override");
        meta.setVariable(param3, childValue3);
        ((Repository)Mockito.doReturn((Object)meta).when((Object)repository)).loadJob((String)Mockito.eq((Object)"test.kjb"), (RepositoryDirectoryInterface)Mockito.anyObject(), (ProgressMonitorListener)Mockito.anyObject(), (String)Mockito.anyObject());
        Variables parentSpace = new Variables();
        parentSpace.setVariable(param1, parentValue1);
        parentSpace.setVariable(param2, parentValue2);
        jobExecutorMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jobExecutorMeta.setFileName("/home/admin/test.kjb");
        jobExecutorMeta.getParameters().setInheritingAllVariables(false);
        JobMeta jobMeta = JobExecutorMeta.loadJobMeta((JobExecutorMeta)jobExecutorMeta, (Repository)repository, (VariableSpace)parentSpace);
        Assert.assertEquals(null, (Object)jobMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)jobMeta.getVariable(param2));
        Assert.assertEquals((Object)childValue3, (Object)jobMeta.getVariable(param3));
        jobExecutorMeta.getParameters().setInheritingAllVariables(true);
        jobMeta = JobExecutorMeta.loadJobMeta((JobExecutorMeta)jobExecutorMeta, (Repository)repository, (VariableSpace)parentSpace);
        Assert.assertEquals((Object)parentValue1, (Object)jobMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)jobMeta.getVariable(param2));
        Assert.assertEquals((Object)childValue3, (Object)jobMeta.getVariable(param3));
    }
}

