/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ivwloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

public class VWLoadMocker {
    private int bufferSize;
    private int errorsAllowed;
    private String delimeter = "\\|";
    private String lineSeparator = System.getProperty("line.separator");
    private String errorFileName;
    private int processed;
    private int loaded;
    private int errors;

    public static void main(String[] args) {
        System.out.println("Start VWLOADMOCKER");
        int exitStatus = 0;
        try {
            File tempErrorFile = File.createTempFile("error_test", ".txt");
            File tempFile = File.createTempFile("test", ".txt");
            tempErrorFile.deleteOnExit();
            tempFile.deleteOnExit();
            int bufferSize = Integer.decode(args[0] == null ? "5000" : args[0]);
            int errorsAllowed = Integer.decode(args[1] == null ? "0" : args[1]);
            String errorFileName = args[2] == null ? tempErrorFile.getAbsolutePath() : args[2];
            VWLoadMocker vwload = new VWLoadMocker(bufferSize);
            vwload.setErrorsAllowed(errorsAllowed);
            vwload.setErrorFileName(errorFileName);
            Scanner sc = new Scanner(System.in);
            FileWriter out = new FileWriter(tempFile);
            StringBuilder cmd = new StringBuilder();
            String line = null;
            while ((line = sc.nextLine()) != null && !line.contains("\\q")) {
                cmd.append(line);
                out.write(line + '\n' + '\r');
                out.flush();
                if (!line.contains("\\g")) continue;
                exitStatus += vwload.execute(cmd.toString());
                cmd.setLength(0);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(exitStatus);
    }

    public VWLoadMocker(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setErrorsAllowed(int errorsAllowed) {
        this.errorsAllowed = errorsAllowed;
    }

    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(String cmd) {
        BufferedReader rafR = null;
        try {
            block26: {
                System.out.println("Start executing command " + cmd);
                int start = cmd.indexOf("FROM ");
                if (start <= 0) {
                    int end = 1;
                    return end;
                }
                start = cmd.indexOf(39, start);
                int end = cmd.indexOf(39, start + 1);
                String fifo = cmd.substring(++start, end);
                this.processed = 0;
                this.loaded = 0;
                this.errors = 0;
                boolean notStopOnError = this.errorsAllowed == 0;
                File raf = new File(fifo);
                rafR = new BufferedReader(new FileReader(raf), this.bufferSize);
                System.out.println("Start reading from file " + fifo);
                if (!raf.exists()) {
                    System.out.println("Break fifo not exist");
                    int n = this.status();
                    return n;
                }
                do {
                    String data;
                    if ((data = rafR.readLine()) == null) {
                        System.out.println("Break fifo end");
                        break block26;
                    }
                    System.out.println("Readed from fifo " + data);
                    ++this.processed;
                    String[] columns = data.trim().split(this.delimeter);
                    Long col = Long.valueOf(columns[0]);
                    if (col >= 10L) {
                        ++this.errors;
                        this.writeError(data);
                        continue;
                    }
                    ++this.loaded;
                    this.writeSuccess(data);
                } while (notStopOnError || this.errors <= this.errorsAllowed);
                System.out.println("Break error count");
            }
            int n = this.status();
            return n;
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                rafR.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        return 1;
    }

    private int status() {
        int result = 0;
        if (this.errors > this.errorsAllowed) {
            this.loaded = 0;
            result = 1;
        }
        System.out.println("processed " + this.processed + " records, loaded " + this.loaded + " records, " + this.errors + " errors");
        return result;
    }

    private void writeSuccess(String data) {
        System.out.println("Successfully loaded ..... " + data);
    }

    private void writeError(String data) throws IOException {
        System.err.println("Error in loading ..... " + data);
        if (this.errorFileName != null) {
            new FileWriter(this.errorFileName, true).write(data + this.lineSeparator);
        }
    }
}

