/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ivwloader;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoader;

public class IngresVectorwise_PDI_12555_Test {
    @Mock
    IngresVectorwiseLoader ingresVectorwiseLoaderMock;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testReplace() {
        String input = "\\\"Name\"";
        String[] from = new String[]{"\""};
        String[] to = new String[]{"\\\""};
        ((IngresVectorwiseLoader)Mockito.doCallRealMethod().when((Object)this.ingresVectorwiseLoaderMock)).replace(Matchers.anyString(), (String[])Matchers.any(String[].class), (String[])Matchers.any(String[].class));
        String actual = this.ingresVectorwiseLoaderMock.replace(input, from, to);
        String expected = "\\\\\"Name\\\"";
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testMasqueradPassword() {
        ((IngresVectorwiseLoader)Mockito.doCallRealMethod().when((Object)this.ingresVectorwiseLoaderMock)).masqueradPassword(Matchers.anyString());
        ((IngresVectorwiseLoader)Mockito.doCallRealMethod().when((Object)this.ingresVectorwiseLoaderMock)).substitute(Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        String cmdUsingVwload = "this is the string without brackets";
        String actual = this.ingresVectorwiseLoaderMock.masqueradPassword(cmdUsingVwload);
        Assert.assertEquals((Object)"", (Object)actual);
        String cmdUsingSql = "/path_to_sql/sql @00.000.000.000,VW[db_user,db_pass]::db_name";
        actual = this.ingresVectorwiseLoaderMock.masqueradPassword(cmdUsingSql);
        String expected = "/path_to_sql/sql @00.000.000.000,VW[username,password]::db_name";
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

