/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ivwloader;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoader;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderData;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderMeta;
import org.pentaho.di.trans.steps.ivwloader.VWLoadMocker;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class IngresVectorwiseTest {
    private static final String IVW_TEMP_PREFIX = "IngresVectorwiseLoaderTest";
    private static final String IVW_TEMP_EXTENSION = ".txt";
    private String lineSeparator = System.getProperty("line.separator");
    private static StepMockHelper<IngresVectorwiseLoaderMeta, IngresVectorwiseLoaderData> stepMockHelper;
    private String[] fieldStream = new String[]{"Number data", "String data"};
    private Object[] row = new Object[]{1L, "another data"};
    private Object[] row2 = new Object[]{2L, "another data2"};
    private Object[] row3 = new Object[]{3L, "another data3"};
    private Object[] wrongRow = new Object[]{10000L, "wrong data"};
    private List<Object[]> wrongRows = new ArrayList<Object[]>();
    private List<Object[]> rows = new ArrayList<Object[]>();

    public IngresVectorwiseTest() {
        this.rows.add(this.row);
        this.rows.add(this.row2);
        this.rows.add(this.row3);
        this.wrongRows.add(this.row);
        this.wrongRows.add(this.wrongRow);
        this.wrongRows.add(this.row3);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        stepMockHelper = new StepMockHelper<IngresVectorwiseLoaderMeta, IngresVectorwiseLoaderData>("INGRES_VECTORWISE_TEST", IngresVectorwiseLoaderMeta.class, IngresVectorwiseLoaderData.class);
        stepMockHelper.redirectLog(System.out, LogLevel.ROWLEVEL);
        Mockito.when((Object)IngresVectorwiseTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        stepMockHelper.cleanUp();
    }

    @Test
    public void testGuiErrors() {
        try {
            int r = this.wrongRows.size();
            BaseStep step = this.doOutput(this.wrongRows, "0");
            ((IngresVectorwiseLoader)step).vwLoadMonitorThread.join();
            Assert.assertEquals((long)0L, (long)step.getLinesOutput());
            Assert.assertEquals((long)r, (long)step.getLinesRead());
            Assert.assertEquals((long)r, (long)step.getLinesWritten());
            Assert.assertEquals((long)1L, (long)step.getLinesRejected());
            Assert.assertEquals((long)1L, (long)step.getErrors());
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGuiErrorsWithErrorsAllowed() {
        try {
            int r = this.wrongRows.size();
            BaseStep step = this.doOutput(this.wrongRows, "2");
            ((IngresVectorwiseLoader)step).vwLoadMonitorThread.join();
            Assert.assertEquals((long)(r - 1), (long)step.getLinesOutput());
            Assert.assertEquals((long)r, (long)step.getLinesRead());
            Assert.assertEquals((long)r, (long)step.getLinesWritten());
            Assert.assertEquals((long)1L, (long)step.getLinesRejected());
            Assert.assertEquals((long)0L, (long)step.getErrors());
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGuiSuccess() {
        try {
            int r = this.rows.size();
            BaseStep step = this.doOutput(this.rows, "0");
            ((IngresVectorwiseLoader)step).vwLoadMonitorThread.join();
            Assert.assertEquals((long)r, (long)step.getLinesOutput());
            Assert.assertEquals((long)r, (long)step.getLinesRead());
            Assert.assertEquals((long)r, (long)step.getLinesWritten());
            Assert.assertEquals((long)0L, (long)step.getLinesRejected());
            Assert.assertEquals((long)0L, (long)step.getErrors());
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testWaitForFinish() {
        try {
            int r = this.rows.size();
            BaseStep step = this.doOutput(this.wrongRows, "2");
            Assert.assertEquals((long)(r - 1), (long)step.getLinesOutput());
            Assert.assertEquals((long)r, (long)step.getLinesRead());
            Assert.assertEquals((long)r, (long)step.getLinesWritten());
            Assert.assertEquals((long)1L, (long)step.getLinesRejected());
            Assert.assertEquals((long)0L, (long)step.getErrors());
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    @Ignore
    public void testVWLoadMocker() {
        String cmd = "java -cp . -Duser.dir=" + VWLoadMocker.class.getProtectionDomain().getCodeSource().getLocation().getPath() + " org.pentaho.di.trans.steps.ivwloader.VWLoadMocker 5000 0 /tmp/error.txt";
        try {
            System.out.println(cmd);
            Process pr = Runtime.getRuntime().exec(cmd);
            pr.getOutputStream().write(("testVWLoadMaker" + this.lineSeparator).getBytes());
            pr.getOutputStream().flush();
            pr.getOutputStream().write(("\\q" + this.lineSeparator).getBytes());
            pr.getOutputStream().flush();
            int i = pr.waitFor();
            System.out.println(i);
            Assert.assertEquals((long)0L, (long)i);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testNoDatabaseConnection() {
        IngresVectorwiseLoaderData ivwData = new IngresVectorwiseLoaderData();
        IngresVectorwiseLoaderMeta ivwMeta = new IngresVectorwiseLoaderMeta();
        IngresVectorwiseLoaderTest ivwLoader = new IngresVectorwiseLoaderTest(IngresVectorwiseTest.stepMockHelper.stepMeta, (StepDataInterface)ivwData, 0, IngresVectorwiseTest.stepMockHelper.transMeta, IngresVectorwiseTest.stepMockHelper.trans);
        Assert.assertFalse((boolean)ivwLoader.init((StepMetaInterface)ivwMeta, (StepDataInterface)ivwData));
        try {
            ivwLoader.verifyDatabaseConnection();
            Assert.fail((String)"Database Connection is not null, this fails the test.");
        }
        catch (KettleException aKettleException) {
            MatcherAssert.assertThat((Object)aKettleException.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no connection defined in this step."));
        }
    }

    private File createTemplateFile() throws IOException {
        File f = File.createTempFile(IVW_TEMP_PREFIX, IVW_TEMP_EXTENSION);
        f.deleteOnExit();
        return f;
    }

    private BaseStep doOutput(List<Object[]> rows, String maxErrorsNumber) throws KettleException {
        IngresVectorwiseLoaderData ivwData = new IngresVectorwiseLoaderData();
        IngresVectorwiseLoaderTest ivwLoader = new IngresVectorwiseLoaderTest(IngresVectorwiseTest.stepMockHelper.stepMeta, (StepDataInterface)ivwData, 0, IngresVectorwiseTest.stepMockHelper.transMeta, IngresVectorwiseTest.stepMockHelper.trans);
        DatabaseMeta defMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getDatabaseMeta()).thenReturn((Object)defMeta);
        Mockito.when((Object)defMeta.getQuotedSchemaTableCombination(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"test_table");
        ivwLoader.init((StepMetaInterface)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)ivwData);
        RowSet rowSet = stepMockHelper.getMockInputRowSet(rows);
        ivwLoader.addRowSetToInputRowSets(rowSet);
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).isUsingVwload()).thenReturn((Object)true);
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getBufferSize()).thenReturn((Object)"5000");
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getMaxNrErrors()).thenReturn((Object)maxErrorsNumber);
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getFieldStream()).thenReturn((Object)this.fieldStream);
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getFieldDatabase()).thenReturn((Object)this.fieldStream);
        File errorFile = new File("/tmp/error.txt");
        File fifoFile = new File("/tmp/fifo");
        try {
            errorFile = this.createTemplateFile();
            fifoFile = this.createTemplateFile();
            boolean bl = fifoFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getErrorFileName()).thenReturn((Object)errorFile.getPath());
        Mockito.when((Object)((IngresVectorwiseLoaderMeta)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface).getFifoFileName()).thenReturn((Object)fifoFile.getPath());
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ivwLoader.setInputRowMeta(inputRowMeta);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        ValueMetaInteger valueMetaInteger = new ValueMetaInteger();
        ValueMetaString valueMetaString = new ValueMetaString();
        Mockito.when((Object)inputRowMeta.getValueMeta(0)).thenReturn((Object)valueMetaInteger);
        Mockito.when((Object)inputRowMeta.getValueMeta(1)).thenReturn((Object)valueMetaString);
        Mockito.when((Object)inputRowMeta.indexOfValue(this.fieldStream[0])).thenReturn((Object)0);
        Mockito.when((Object)inputRowMeta.indexOfValue(this.fieldStream[1])).thenReturn((Object)1);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        for (Object[] row1 : rows) {
            ivwLoader.processRow((StepMetaInterface)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)ivwData);
        }
        ivwLoader.processRow((StepMetaInterface)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)ivwData);
        ivwLoader.dispose((StepMetaInterface)IngresVectorwiseTest.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)ivwData);
        ivwLoader.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_EXECUTION_STOP, new long[0]);
        return ivwLoader;
    }

    private class IngresVectorwiseLoaderTest
    extends IngresVectorwiseLoader {
        public IngresVectorwiseLoaderTest(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        }

        public String createCommandLine(IngresVectorwiseLoaderMeta meta) throws KettleException {
            String userDir;
            String bufferSizeString = this.environmentSubstitute(meta.getBufferSize());
            int bufferSize = Utils.isEmpty((CharSequence)bufferSizeString) ? 5000 : Const.toInt((String)bufferSizeString, (int)5000);
            Class<VWLoadMocker> vwload = VWLoadMocker.class;
            try {
                userDir = Paths.get(vwload.getProtectionDomain().getCodeSource().getLocation().toURI()).toString();
            }
            catch (URISyntaxException e) {
                throw new KettleException((Throwable)e);
            }
            return "java -cp . -Duser.dir=" + userDir + ' ' + vwload.getCanonicalName() + ' ' + bufferSize + ' ' + meta.getMaxNrErrors() + ' ' + meta.getErrorFileName();
        }
    }
}

