/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.insertupdate;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdate;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateData;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class InsertUpdateMetaTest {
    LoadSaveTester loadSaveTester;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMeta stepMeta;
    private InsertUpdate upd;
    private InsertUpdateData ud;
    private InsertUpdateMeta umi;
    private StepMockHelper<InsertUpdateMeta, InsertUpdateData> mockHelper;

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.umi = new InsertUpdateMeta();
        this.ud = new InsertUpdateData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.umi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.umi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.upd = new InsertUpdate(this.stepMeta, (StepDataInterface)this.ud, 1, transMeta, trans);
        this.upd.copyVariablesFrom((VariableSpace)transMeta);
        this.mockHelper = new StepMockHelper<InsertUpdateMeta, InsertUpdateData>("insertUpdate", InsertUpdateMeta.class, InsertUpdateData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Mockito.any(), (LoggingObjectInterface)Mockito.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)new InsertUpdateMeta());
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testCommitCountFixed() {
        this.umi.setCommitSize("100");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.umi.setCommitSize("${max.sz}");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testProvidesModeler() throws Exception {
        InsertUpdateMeta insertUpdateMeta = new InsertUpdateMeta();
        insertUpdateMeta.setUpdateLookup(new String[]{"f1", "f2", "f3"});
        insertUpdateMeta.setUpdateStream(new String[]{"s4", "s5", "s6"});
        InsertUpdateData tableOutputData = new InsertUpdateData();
        tableOutputData.insertRowMeta = (RowMetaInterface)Mockito.mock(RowMeta.class);
        Assert.assertEquals((Object)tableOutputData.insertRowMeta, (Object)insertUpdateMeta.getRowMeta((StepDataInterface)tableOutputData));
        Assert.assertEquals((long)3L, (long)insertUpdateMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", insertUpdateMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", insertUpdateMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", insertUpdateMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)insertUpdateMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", insertUpdateMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", insertUpdateMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", insertUpdateMeta.getStreamFields().get(2));
    }

    @Test
    public void testCommitCountMissedVar() {
        this.umi.setCommitSize("missed-var");
        try {
            this.umi.getCommitSize((VariableSpace)this.upd);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setUpLoadSave() throws Exception {
        List<String> attributes = Arrays.asList("schemaName", "tableName", "databaseMeta", "keyStream", "keyLookup", "keyCondition", "keyStream2", "updateLookup", "updateStream", "update", "commitSize", "updateBypassed");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "getSchemaName");
                this.put("tableName", "getTableName");
                this.put("databaseMeta", "getDatabaseMeta");
                this.put("keyStream", "getKeyStream");
                this.put("keyLookup", "getKeyLookup");
                this.put("keyCondition", "getKeyCondition");
                this.put("keyStream2", "getKeyStream2");
                this.put("updateLookup", "getUpdateLookup");
                this.put("updateStream", "getUpdateStream");
                this.put("update", "getUpdate");
                this.put("commitSize", "getCommitSizeVar");
                this.put("updateBypassed", "isUpdateBypassed");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "setSchemaName");
                this.put("tableName", "setTableName");
                this.put("databaseMeta", "setDatabaseMeta");
                this.put("keyStream", "setKeyStream");
                this.put("keyLookup", "setKeyLookup");
                this.put("keyCondition", "setKeyCondition");
                this.put("keyStream2", "setKeyStream2");
                this.put("updateLookup", "setUpdateLookup");
                this.put("updateStream", "setUpdateStream");
                this.put("update", "setUpdate");
                this.put("commitSize", "setCommitSize");
                this.put("updateBypassed", "setUpdateBypassed");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keyStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyCondition", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyStream2", stringArrayLoadSaveValidator);
        attrValidatorMap.put("updateLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("updateStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        attrValidatorMap.put("update", new ArrayLoadSaveValidator<Boolean>(new BooleanLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(boolean[].class.getCanonicalName(), new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 3));
        this.loadSaveTester = new LoadSaveTester<InsertUpdateMeta>(InsertUpdateMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testErrorProcessRow() throws KettleException {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Mockito.any(), (LoggingObjectInterface)Mockito.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)new InsertUpdateMeta());
        InsertUpdate insertUpdateStep = new InsertUpdate(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        insertUpdateStep = (InsertUpdate)Mockito.spy((Object)insertUpdateStep);
        ((InsertUpdate)Mockito.doReturn((Object)new Object[0]).when((Object)insertUpdateStep)).getRow();
        insertUpdateStep.first = false;
        ((InsertUpdateData)this.mockHelper.processRowsStepDataInterface).lookupParameterRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((InsertUpdateData)this.mockHelper.processRowsStepDataInterface).keynrs = new int[0];
        ((InsertUpdateData)this.mockHelper.processRowsStepDataInterface).db = (Database)Mockito.mock(Database.class);
        ((InsertUpdateData)this.mockHelper.processRowsStepDataInterface).valuenrs = new int[0];
        ((InsertUpdate)Mockito.doThrow((Throwable)new KettleStepException("Test exception")).when((Object)insertUpdateStep)).putRow((RowMetaInterface)Mockito.any(), (Object[])Mockito.any());
        boolean result = insertUpdateStep.processRow(this.mockHelper.processRowsStepMetaInterface, this.mockHelper.processRowsStepDataInterface);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void keyStream2ProcessRow() throws KettleException {
        Database database;
        InsertUpdate insertUpdateStep = new InsertUpdate(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        insertUpdateStep.setInputRowMeta((RowMetaInterface)Mockito.mock(RowMetaInterface.class));
        insertUpdateStep = (InsertUpdate)Mockito.spy((Object)insertUpdateStep);
        InsertUpdateMeta insertUpdateMeta = new InsertUpdateMeta();
        insertUpdateMeta.setKeyStream(new String[]{"test_field"});
        insertUpdateMeta.setKeyCondition(new String[]{"test_condition"});
        insertUpdateMeta.setKeyStream2(new String[0]);
        insertUpdateMeta.setUpdateLookup(new String[0]);
        insertUpdateMeta.setKeyLookup(new String[0]);
        insertUpdateMeta.setUpdateBypassed(true);
        insertUpdateMeta.setDatabaseMeta((DatabaseMeta)Mockito.mock(DatabaseMeta.class));
        ((InsertUpdateData)this.mockHelper.processRowsStepDataInterface).db = database = (Database)Mockito.mock(Database.class);
        ((Database)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)database)).getConnection();
        ((InsertUpdate)Mockito.doNothing().when((Object)insertUpdateStep)).lookupValues((RowMetaInterface)Mockito.any(), (Object[])Mockito.any());
        ((InsertUpdate)Mockito.doNothing().when((Object)insertUpdateStep)).putRow((RowMetaInterface)Mockito.any(), (Object[])Mockito.any());
        ((InsertUpdate)Mockito.doReturn((Object)new Object[0]).when((Object)insertUpdateStep)).getRow();
        insertUpdateStep.first = true;
        insertUpdateMeta.afterInjectionSynchronization();
        insertUpdateStep.processRow((StepMetaInterface)insertUpdateMeta, this.mockHelper.processRowsStepDataInterface);
        Assert.assertEquals((long)insertUpdateMeta.getKeyStream().length, (long)insertUpdateMeta.getKeyStream2().length);
    }
}

