/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.DataFormat;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class InfobrightLoaderMetaTest {
    LoadSaveTester loadSaveTester;
    Class<InfobrightLoaderMeta> testMetaClass = InfobrightLoaderMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("agentPort", "debugFile", "charset", "dataFormat");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("charset", new CharsetLoadSaveValidator());
        attrValidatorMap.put("dataFormat", new DataFormatLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<InfobrightLoaderMeta>(this.testMetaClass, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class DataFormatLoadSaveValidator
    implements FieldLoadSaveValidator<DataFormat> {
        final Random rand = new Random();

        @Override
        public DataFormat getTestObject() {
            DataFormat[] vals = DataFormat.values();
            int dfNum = this.rand.nextInt(vals.length);
            DataFormat rtn = vals[dfNum];
            return rtn;
        }

        @Override
        public boolean validateTestObject(DataFormat testObject, Object actual) {
            if (!(actual instanceof DataFormat)) {
                return false;
            }
            DataFormat another = (DataFormat)actual;
            return testObject.toString().equals(another.toString());
        }
    }

    public class CharsetLoadSaveValidator
    implements FieldLoadSaveValidator<Charset> {
        final Random rand = new Random();

        @Override
        public Charset getTestObject() {
            Charset rtn = null;
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            int iterations = this.rand.nextInt(charsets.size());
            Set chit = charsets.entrySet();
            int i = 0;
            for (Map.Entry chEntry : chit) {
                if (i == iterations) {
                    rtn = (Charset)chEntry.getValue();
                    break;
                }
                ++i;
            }
            return rtn;
        }

        @Override
        public boolean validateTestObject(Charset testObject, Object actual) {
            if (!(actual instanceof Charset)) {
                return false;
            }
            Charset another = (Charset)actual;
            return testObject.compareTo(another) == 0;
        }
    }
}

