/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ifnull;

import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.steps.ifnull.IfNullMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PDI_11319Test {
    private Node xmlVersion4;
    private Node xmlVersion5;
    private IfNullMeta meta;

    @Before
    public void init() throws Exception {
        File v4 = new File(this.getClass().getResource("v4.ktr").getFile());
        File v5 = new File(this.getClass().getResource("v5.ktr").getFile());
        this.xmlVersion4 = XMLHandler.loadXMLFile((File)v4);
        this.xmlVersion5 = XMLHandler.loadXMLFile((File)v5);
        this.meta = new IfNullMeta();
    }

    @Test
    public void testLoadXMLVersion4() throws Exception {
        Node nullIfStep = this.getNullIfStep(this.xmlVersion4);
        this.meta.loadXML(nullIfStep, null, (IMetaStore)null);
        Assert.assertFalse((String)"Set Empty String is true", (boolean)this.meta.isSetEmptyStringAll());
        boolean[] expected = new boolean[]{false};
        IfNullMeta.ValueTypes[] actual = this.meta.getValueTypes();
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)"Set empty string value type works incorrectly", (Object)expected[i], (Object)actual[i].isSetTypeEmptyString());
        }
    }

    @Test
    public void testLoadXMLVersion5() throws Exception {
        Node nullIfStep = this.getNullIfStep(this.xmlVersion5);
        this.meta.loadXML(nullIfStep, null, (IMetaStore)null);
        Assert.assertFalse((String)"Set Empty String is true", (boolean)this.meta.isSetEmptyStringAll());
        boolean[] expected = new boolean[]{true, false, false};
        IfNullMeta.ValueTypes[] actual = this.meta.getValueTypes();
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)"Set empty string value type works incorrectly", (Object)expected[i], (Object)actual[i].isSetTypeEmptyString());
        }
    }

    private Node getNullIfStep(Node doc) {
        Node trans = XMLHandler.getSubNode((Node)doc, (String)"transformation");
        List steps = XMLHandler.getNodes((Node)trans, (String)"step");
        Node nullIfStep = null;
        for (Node step : steps) {
            if (!"IfNull".equals(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)step, (String)"type")))) continue;
            nullIfStep = step;
            break;
        }
        return nullIfStep;
    }
}

