/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ifnull;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.ifnull.IfNullMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class IfNullMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("fields", "valueTypes", "selectFields", "selectValuesType", "replaceAllByValue", "replaceAllMask", "setEmptyStringAll");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("fields", "getFields");
                this.put("valueTypes", "getValueTypes");
                this.put("selectFields", "isSelectFields");
                this.put("selectValuesType", "isSelectValuesType");
                this.put("replaceAllByValue", "getReplaceAllByValue");
                this.put("replaceAllMask", "getReplaceAllMask");
                this.put("setEmptyStringAll", "isSetEmptyStringAll");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("fields", "setFields");
                this.put("valueTypes", "setValueTypes");
                this.put("selectFields", "setSelectFields");
                this.put("selectValuesType", "setSelectValuesType");
                this.put("replaceAllByValue", "setReplaceAllByValue");
                this.put("replaceAllMask", "setReplaceAllMask");
                this.put("setEmptyStringAll", "setEmptyStringAll");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 3);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("replaceValue", stringArrayLoadSaveValidator);
        attrValidatorMap.put("typeName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("typereplaceValue", stringArrayLoadSaveValidator);
        attrValidatorMap.put("typereplaceMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("replaceMask", stringArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(boolean[].class.getCanonicalName(), new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 3));
        IfNullMeta.Fields field = new IfNullMeta.Fields();
        field.setFieldName("fieldName");
        field.setReplaceValue("replaceValue");
        field.setReplaceMask("replaceMask");
        field.setEmptyString(true);
        typeValidatorMap.put(IfNullMeta.Fields[].class.getCanonicalName(), new ArrayLoadSaveValidator<IfNullMeta.Fields>(new FieldsLoadSaveValidator(field), 3));
        IfNullMeta.ValueTypes type = new IfNullMeta.ValueTypes();
        type.setTypeName("typeName");
        type.setTypereplaceValue("typereplaceValue");
        type.setTypereplaceMask("typereplaceMask");
        type.setTypeEmptyString(true);
        typeValidatorMap.put(IfNullMeta.ValueTypes[].class.getCanonicalName(), new ArrayLoadSaveValidator<IfNullMeta.ValueTypes>(new ValueTypesLoadSaveValidator(type), 3));
        this.loadSaveTester = new LoadSaveTester<IfNullMeta>(IfNullMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testLoadSave() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testSetDefault() throws Exception {
        IfNullMeta inm = new IfNullMeta();
        inm.setDefault();
        Assert.assertTrue((inm.getValueTypes() != null && inm.getValueTypes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((inm.getFields() != null && inm.getFields().length == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)inm.isSelectFields());
        Assert.assertFalse((boolean)inm.isSelectValuesType());
    }

    public static class ValueTypesLoadSaveValidator
    implements FieldLoadSaveValidator<IfNullMeta.ValueTypes> {
        private final IfNullMeta.ValueTypes defaultValue;

        public ValueTypesLoadSaveValidator(IfNullMeta.ValueTypes defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public IfNullMeta.ValueTypes getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(IfNullMeta.ValueTypes testObject, Object actual) {
            return EqualsBuilder.reflectionEquals((Object)testObject, (Object)actual);
        }
    }

    public static class FieldsLoadSaveValidator
    implements FieldLoadSaveValidator<IfNullMeta.Fields> {
        private final IfNullMeta.Fields defaultValue;

        public FieldsLoadSaveValidator(IfNullMeta.Fields defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public IfNullMeta.Fields getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(IfNullMeta.Fields testObject, Object actual) {
            return EqualsBuilder.reflectionEquals((Object)testObject, (Object)actual);
        }
    }
}

