/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class HTTPPOSTMetaTest {
    LoadSaveTester loadSaveTester;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void testLoadSaveRoundTrip() throws KettleException {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("postAFile", "encoding", "url", "urlInField", "urlField", "requestEntity", "httpLogin", "httpPassword", "proxyHost", "proxyPort", "socketTimeout", "connectionTimeout", "closeIdleConnectionsTime", "argumentField", "argumentParameter", "argumentHeader", "queryField", "queryParameter", "fieldName", "resultCodeFieldName", "responseTimeFieldName", "responseHeaderFieldName");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveBooleanArrayLoadSaveValidator booleanArrayLoadSaveValidator = new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("argumentField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("argumentParameter", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("argumentHeader", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("queryField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("queryParameter", stringArrayLoadSaveValidator);
        this.loadSaveTester = new LoadSaveTester<HTTPPOSTMeta>(HTTPPOSTMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), fieldLoadSaveValidatorAttributeMap, new HashMap());
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void setDefault() {
        HTTPPOSTMeta meta = new HTTPPOSTMeta();
        Assert.assertNull((Object)meta.getEncoding());
        meta.setDefault();
        Assert.assertEquals((Object)"UTF-8", (Object)meta.getEncoding());
    }
}

