/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.trans.steps.http.HTTP;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HttpClientManager.class})
public class HTTPTest {
    private LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
    private RowMetaInterface rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
    private HTTPData data = (HTTPData)Mockito.mock(HTTPData.class);
    private HTTPMeta meta = (HTTPMeta)Mockito.mock(HTTPMeta.class);
    private HTTP http = (HTTP)Mockito.mock(HTTP.class);
    private final String DATA = "This is the description, there's some HTML here, like &lt;strong&gt;this&lt;/strong&gt;. Sometimes this text is another language that might contain these characters:\n&lt;p&gt;\u00e9, \u00e8, \u00f4, \u00e7, \u00e0, \u00ea, \u00e2.&lt;/p&gt; They can, of course, come in uppercase as well: &lt;p&gt;\u00c9, \u00c8 \u00d4, \u00c7, \u00c0, \u00ca, \u00c2&lt;/p&gt;. UTF-8 handles this well.";

    @Before
    public void setup() throws Exception {
        HttpClientManager.HttpClientBuilderFacade builder = (HttpClientManager.HttpClientBuilderFacade)Mockito.mock(HttpClientManager.HttpClientBuilderFacade.class);
        HttpClientManager manager = (HttpClientManager)Mockito.mock(HttpClientManager.class);
        ((HttpClientManager)Mockito.doReturn((Object)builder).when((Object)manager)).createBuilder();
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        ((HttpClientManager.HttpClientBuilderFacade)Mockito.doReturn((Object)client).when((Object)builder)).build();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        ((CloseableHttpClient)Mockito.doReturn((Object)response).when((Object)client)).execute((HttpUriRequest)Matchers.any(HttpGet.class));
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)new ByteArrayInputStream("This is the description, there's some HTML here, like &lt;strong&gt;this&lt;/strong&gt;. Sometimes this text is another language that might contain these characters:\n&lt;p&gt;\u00e9, \u00e8, \u00f4, \u00e7, \u00e0, \u00ea, \u00e2.&lt;/p&gt; They can, of course, come in uppercase as well: &lt;p&gt;\u00c9, \u00c8 \u00d4, \u00c7, \u00c0, \u00ca, \u00c2&lt;/p&gt;. UTF-8 handles this well.".getBytes()));
        ((CloseableHttpResponse)Mockito.doReturn((Object)entity).when((Object)response)).getEntity();
        PowerMockito.mockStatic(HttpClientManager.class, (Class[])new Class[0]);
        Mockito.when((Object)HttpClientManager.getInstance()).thenReturn((Object)manager);
        Whitebox.setInternalState((Object)this.data, (String)"realUrl", (Object)"http://pentaho.com");
        Whitebox.setInternalState((Object)this.data, (String)"argnrs", (Object)new int[0]);
        ((HTTPMeta)Mockito.doReturn((Object)false).when((Object)this.meta)).isUrlInField();
        ((HTTPMeta)Mockito.doReturn((Object)"body").when((Object)this.meta)).getFieldName();
        ((LogChannelInterface)Mockito.doReturn((Object)false).when((Object)this.log)).isDetailed();
        ((HTTP)Mockito.doCallRealMethod().when((Object)this.http)).callHttpService((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class));
        ((HTTP)Mockito.doReturn((Object)200).when((Object)this.http)).requestStatusCode((HttpResponse)Matchers.any(CloseableHttpResponse.class));
        ((HTTP)Mockito.doReturn((Object)new Header[0]).when((Object)this.http)).searchForHeaders((CloseableHttpResponse)Matchers.any(CloseableHttpResponse.class));
        Whitebox.setInternalState((Object)this.http, (String)"log", (Object)this.log);
        Whitebox.setInternalState((Object)this.http, (String)"data", (Object)this.data);
        Whitebox.setInternalState((Object)this.http, (String)"meta", (Object)this.meta);
    }

    @Test
    public void callHttpServiceWithUTF8Encoding() throws Exception {
        ((HTTPMeta)Mockito.doReturn((Object)"UTF-8").when((Object)this.meta)).getEncoding();
        Assert.assertEquals((Object)"This is the description, there's some HTML here, like &lt;strong&gt;this&lt;/strong&gt;. Sometimes this text is another language that might contain these characters:\n&lt;p&gt;\u00e9, \u00e8, \u00f4, \u00e7, \u00e0, \u00ea, \u00e2.&lt;/p&gt; They can, of course, come in uppercase as well: &lt;p&gt;\u00c9, \u00c8 \u00d4, \u00c7, \u00c0, \u00ca, \u00c2&lt;/p&gt;. UTF-8 handles this well.", (Object)this.http.callHttpService(this.rmi, new Object[]{0})[0]);
    }

    @Test
    public void callHttpServiceWithoutEncoding() throws Exception {
        ((HTTPMeta)Mockito.doReturn(null).when((Object)this.meta)).getEncoding();
        Assert.assertNotEquals((Object)"This is the description, there's some HTML here, like &lt;strong&gt;this&lt;/strong&gt;. Sometimes this text is another language that might contain these characters:\n&lt;p&gt;\u00e9, \u00e8, \u00f4, \u00e7, \u00e0, \u00ea, \u00e2.&lt;/p&gt; They can, of course, come in uppercase as well: &lt;p&gt;\u00c9, \u00c8 \u00d4, \u00c7, \u00c0, \u00ca, \u00c2&lt;/p&gt;. UTF-8 handles this well.", (Object)this.http.callHttpService(this.rmi, new Object[]{0})[0]);
    }
}

