/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.util.Arrays;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.groupby.GroupBy;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class GroupByNullInputTest {
    public static final int NUMBER_OF_COLUMNS = 1;
    public static final String ANY_FIELD_NAME = "anyFieldName";
    static StepMockHelper<GroupByMeta, GroupByData> mockHelper;
    private GroupBy step;
    private GroupByData groupByStepData;
    private GroupByMeta groupByStepMeta;
    private RowMetaInterface rowMetaInterfaceMock;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<GroupByMeta, GroupByData>("Group By", GroupByMeta.class, GroupByData.class);
        Mockito.when((Object)GroupByNullInputTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)GroupByNullInputTest.mockHelper.logChannelInterface);
        Mockito.when((Object)GroupByNullInputTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        mockHelper.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        this.groupByStepData = new GroupByData();
        this.groupByStepMeta = new GroupByMeta();
        Mockito.when((Object)GroupByNullInputTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)this.groupByStepMeta);
        this.groupByStepData.inputRowMeta = this.rowMetaInterfaceMock = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.groupByStepData.aggMeta = this.rowMetaInterfaceMock;
        this.step = new GroupBy(GroupByNullInputTest.mockHelper.stepMeta, (StepDataInterface)this.groupByStepData, 0, GroupByNullInputTest.mockHelper.transMeta, GroupByNullInputTest.mockHelper.trans);
    }

    private void setAggregationTypesAndInitData(int[] aggregationTypes) {
        int countOfAggregations = aggregationTypes.length;
        this.groupByStepData.subjectnrs = new int[countOfAggregations];
        System.arraycopy(aggregationTypes, 0, this.groupByStepData.subjectnrs, 0, countOfAggregations);
        this.groupByStepMeta.setAggregateType(aggregationTypes);
        Object[] fieldNames = new String[countOfAggregations];
        Arrays.fill(fieldNames, ANY_FIELD_NAME);
        this.groupByStepMeta.setAggregateField((String[])fieldNames);
        this.groupByStepData.subjectnrs = new int[countOfAggregations];
        this.groupByStepData.previousSums = new Object[countOfAggregations];
        this.groupByStepData.counts = new long[countOfAggregations];
        this.groupByStepData.previousAvgCount = new long[countOfAggregations];
        this.groupByStepData.previousAvgSum = new Object[countOfAggregations];
        Arrays.fill(this.groupByStepData.previousSums, (Object)0);
        Arrays.fill(this.groupByStepData.previousAvgCount, 0L);
        Arrays.fill(this.groupByStepData.previousAvgSum, (Object)0);
    }

    @Test
    public void testNullInputDataForStandardDeviation() throws KettleValueException {
        this.setAggregationTypesAndInitData(new int[]{15});
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)this.rowMetaInterfaceMock.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        Object[] row1 = new Object[1];
        Arrays.fill(row1, null);
        this.step.newAggregate(row1);
        this.step.calcAggregate(row1);
        Object[] aggregateResult = this.step.getAggregateResult();
        Assert.assertNull((String)"Returns null if aggregation is null", (Object)aggregateResult[0]);
    }

    @Test
    public void testNullInputDataForAggregationWithNumbers() throws KettleValueException {
        this.setAggregationTypesAndInitData(new int[]{1, 2, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15});
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)this.rowMetaInterfaceMock.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        Object[] row1 = new Object[1];
        Arrays.fill(row1, null);
        this.step.newAggregate(row1);
        this.step.calcAggregate(row1);
        Object[] aggregateResult = this.step.getAggregateResult();
        Assert.assertNull((String)"Returns null if aggregation is null", (Object)aggregateResult[0]);
    }

    @Test
    public void testNullInputDataForAggregationWithNumbersMedianFunction() throws KettleValueException {
        this.setAggregationTypesAndInitData(new int[]{3, 4});
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)this.rowMetaInterfaceMock.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        this.groupByStepMeta.setValueField(new String[]{"3", "3"});
        Object[] row1 = new Object[1];
        Arrays.fill(row1, null);
        this.step.newAggregate(row1);
        this.step.calcAggregate(row1);
        this.step.getAggregateResult();
    }

    @Test
    public void testNullInputDataForAggregationWithStrings() throws KettleValueException {
        this.setAggregationTypesAndInitData(new int[]{8, 16, 17, 18});
        this.groupByStepMeta.setValueField(new String[]{","});
        this.groupByStepMeta.setSubjectField(new String[]{ANY_FIELD_NAME, ANY_FIELD_NAME});
        ValueMetaString vmi = new ValueMetaString();
        Mockito.when((Object)this.rowMetaInterfaceMock.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        Object[] row1 = new Object[1];
        Arrays.fill(row1, null);
        this.step.newAggregate(row1);
        this.step.calcAggregate(row1);
        Object[] row2 = new Object[1];
        Arrays.fill(row2, null);
        this.step.calcAggregate(row2);
        Object[] row3 = new Object[1];
        Arrays.fill(row3, null);
        this.step.calcAggregate(row3);
        this.step.getAggregateResult();
    }
}

