/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.groupby.GroupBy;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class GroupByNewAggregateTest {
    static StepMockHelper<GroupByMeta, GroupByData> mockHelper;
    GroupBy step;
    GroupByData data;
    static List<Integer> strings;
    static List<Integer> statistics;
    static int def;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<GroupByMeta, GroupByData>("Group By", GroupByMeta.class, GroupByData.class);
        Mockito.when((Object)GroupByNewAggregateTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)GroupByNewAggregateTest.mockHelper.logChannelInterface);
        Mockito.when((Object)GroupByNewAggregateTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
        strings = new ArrayList<Integer>();
        strings.add(8);
        strings.add(16);
        statistics = new ArrayList<Integer>();
        statistics.add(3);
        statistics.add(4);
    }

    @AfterClass
    public static void cleanUp() {
        mockHelper.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        RowMetaInterface rmi;
        this.data = new GroupByData();
        this.data.subjectnrs = new int[18];
        int[] arr = new int[18];
        Object[] arrF = new String[18];
        this.data.previousSums = new Object[18];
        this.data.previousAvgCount = new long[18];
        this.data.previousAvgSum = new Object[18];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = i + 1;
            this.data.subjectnrs[i] = i;
        }
        Arrays.fill(arrF, "x");
        Arrays.fill(this.data.previousSums, (Object)11);
        Arrays.fill(this.data.previousAvgCount, 12L);
        Arrays.fill(this.data.previousAvgSum, (Object)13);
        GroupByMeta meta = new GroupByMeta();
        meta.setAggregateType(arr);
        meta.setAggregateField((String[])arrF);
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)GroupByNewAggregateTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        this.data.inputRowMeta = rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rmi.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        this.data.aggMeta = rmi;
        this.data.agg = new Object[]{def};
        this.data.counts = new long[]{1L};
        this.data.previousSums = new Object[]{18};
        this.step = new GroupBy(GroupByNewAggregateTest.mockHelper.stepMeta, (StepDataInterface)this.data, 0, GroupByNewAggregateTest.mockHelper.transMeta, GroupByNewAggregateTest.mockHelper.trans);
    }

    @Test
    public void newAggregateInitializationTest() {
        Object[] r = new Object[18];
        Arrays.fill(r, null);
        this.step.newAggregate(r);
        Object[] agg = this.data.agg;
        Assert.assertEquals((String)"All possible aggregation cases considered", (int)18, (int)agg.length);
        for (int i = 0; i < agg.length; ++i) {
            int type = i + 1;
            if (strings.contains(type)) {
                Assert.assertTrue((String)("This is appendable type, type=" + type), (boolean)(agg[i] instanceof Appendable));
                continue;
            }
            if (statistics.contains(type)) {
                Assert.assertTrue((String)("This is collection, type=" + type), (boolean)(agg[i] instanceof Collection));
                continue;
            }
            Assert.assertNull((String)("Aggregation initialized with null, type=" + type), (Object)agg[i]);
        }
    }

    static {
        def = -113;
    }
}

