/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ValueMetaFactory.class})
public class GroupByMetaGetFieldsTest {
    private GroupByMeta groupByMeta;
    private RowMetaInterface rowMeta;
    private RowMetaInterface[] mockInfo;
    private StepMeta mockNextStep;
    private VariableSpace mockSpace;
    private IMetaStore mockIMetaStore;

    @Before
    public void setup() throws KettlePluginException {
        this.rowMeta = (RowMetaInterface)Mockito.spy((Object)new RowMeta());
        this.groupByMeta = (GroupByMeta)Mockito.spy((Object)new GroupByMeta());
        PowerMockito.mockStatic(ValueMetaFactory.class, (Class[])new Class[0]);
        Mockito.when((Object)ValueMetaFactory.createValueMeta((int)Matchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)ValueMetaFactory.createValueMeta((String)Matchers.anyString(), (int)Matchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)ValueMetaFactory.createValueMeta((String)"maxDate", (int)3, (int)-1, (int)-1)).thenReturn((Object)new ValueMetaDate("maxDate"));
        Mockito.when((Object)ValueMetaFactory.createValueMeta((String)"minDate", (int)3, (int)-1, (int)-1)).thenReturn((Object)new ValueMetaDate("minDate"));
        Mockito.when((Object)ValueMetaFactory.createValueMeta((String)"countDate", (int)5, (int)-1, (int)-1)).thenReturn((Object)new ValueMetaInteger("countDate"));
        Mockito.when((Object)ValueMetaFactory.getValueMetaName((int)3)).thenReturn((Object)"Date");
        Mockito.when((Object)ValueMetaFactory.getValueMetaName((int)5)).thenReturn((Object)"Integer");
    }

    @After
    public void cleanup() {
    }

    @Test
    public void getFieldsWithSubject_WithFormat() {
        ValueMetaDate valueMeta = new ValueMetaDate();
        valueMeta.setConversionMask("yyyy-MM-dd");
        valueMeta.setName("date");
        ((RowMetaInterface)Mockito.doReturn((Object)valueMeta).when((Object)this.rowMeta)).searchValueMeta("date");
        this.groupByMeta.setSubjectField(new String[]{"date"});
        this.groupByMeta.setGroupField(new String[0]);
        this.groupByMeta.setAggregateField(new String[]{"maxDate"});
        this.groupByMeta.setAggregateType(new int[]{6});
        this.groupByMeta.getFields(this.rowMeta, "Group by", this.mockInfo, this.mockNextStep, this.mockSpace, null, this.mockIMetaStore);
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).clear();
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).addRowMeta((RowMetaInterface)Matchers.any());
        Assert.assertEquals((Object)"yyyy-MM-dd", (Object)this.rowMeta.searchValueMeta("maxDate").getConversionMask());
    }

    @Test
    public void getFieldsWithSubject_NoFormat() {
        ValueMetaDate valueMeta = new ValueMetaDate();
        valueMeta.setName("date");
        ((RowMetaInterface)Mockito.doReturn((Object)valueMeta).when((Object)this.rowMeta)).searchValueMeta("date");
        this.groupByMeta.setSubjectField(new String[]{"date"});
        this.groupByMeta.setGroupField(new String[0]);
        this.groupByMeta.setAggregateField(new String[]{"minDate"});
        this.groupByMeta.setAggregateType(new int[]{5});
        this.groupByMeta.getFields(this.rowMeta, "Group by", this.mockInfo, this.mockNextStep, this.mockSpace, null, this.mockIMetaStore);
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).clear();
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).addRowMeta((RowMetaInterface)Matchers.any());
        Assert.assertEquals(null, (Object)this.rowMeta.searchValueMeta("minDate").getConversionMask());
    }

    @Test
    public void getFieldsWithoutSubject() {
        ValueMetaDate valueMeta = new ValueMetaDate();
        valueMeta.setName("date");
        ((RowMetaInterface)Mockito.doReturn((Object)valueMeta).when((Object)this.rowMeta)).searchValueMeta("date");
        this.groupByMeta.setSubjectField(new String[]{null});
        this.groupByMeta.setGroupField(new String[]{"date"});
        this.groupByMeta.setAggregateField(new String[]{"countDate"});
        this.groupByMeta.setAggregateType(new int[]{18});
        this.groupByMeta.getFields(this.rowMeta, "Group by", this.mockInfo, this.mockNextStep, this.mockSpace, null, this.mockIMetaStore);
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).clear();
        ((RowMetaInterface)Mockito.verify((Object)this.rowMeta, (VerificationMode)Mockito.times((int)1))).addRowMeta((RowMetaInterface)Matchers.any());
        Assert.assertNotNull((Object)this.rowMeta.searchValueMeta("countDate"));
    }
}

