/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.groupby.GroupBy;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class GroupByAggregationNullsTest {
    static StepMockHelper<GroupByMeta, GroupByData> mockHelper;
    GroupBy step;
    GroupByData data;
    int def = -113;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<GroupByMeta, GroupByData>("Group By", GroupByMeta.class, GroupByData.class);
        Mockito.when((Object)GroupByAggregationNullsTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)GroupByAggregationNullsTest.mockHelper.logChannelInterface);
        Mockito.when((Object)GroupByAggregationNullsTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        mockHelper.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        RowMetaInterface rmi;
        this.data = new GroupByData();
        this.data.subjectnrs = new int[]{0};
        GroupByMeta meta = new GroupByMeta();
        meta.setAggregateType(new int[]{5});
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)GroupByAggregationNullsTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        this.data.inputRowMeta = rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.data.outputRowMeta = rmi;
        Mockito.when((Object)rmi.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        this.data.aggMeta = rmi;
        this.data.agg = new Object[]{this.def};
        this.step = new GroupBy(GroupByAggregationNullsTest.mockHelper.stepMeta, (StepDataInterface)this.data, 0, GroupByAggregationNullsTest.mockHelper.transMeta, GroupByAggregationNullsTest.mockHelper.trans);
    }

    @Test
    public void calcAggregateResultTestMin_1_Test() throws KettleValueException {
        this.step.setMinNullIsValued(true);
        this.step.calcAggregate(new Object[]{null});
        Assert.assertNull((String)"Value is set", (Object)this.data.agg[0]);
    }

    @Test
    public void calcAggregateResultTestMin_2_Test() throws KettleValueException {
        this.step.setMinNullIsValued(true);
        this.step.calcAggregate(new Object[]{null});
        Assert.assertNull((String)"Value is set", (Object)this.data.agg[0]);
    }

    @Test
    public void calcAggregateResultTestMin_5_Test() throws KettleValueException {
        this.step.calcAggregate(new Object[]{null});
        Assert.assertEquals((String)"Value is NOT set", (Object)this.def, (Object)this.data.agg[0]);
    }

    @Test
    public void calcAggregateResultTestMin_3_Test() throws KettleValueException {
        this.step.setMinNullIsValued(false);
        this.step.calcAggregate(new Object[]{null});
        Assert.assertEquals((String)"Value is NOT set", (Object)this.def, (Object)this.data.agg[0]);
    }

    @Test
    public void getMinAggregateResultFirstValIsNullTest() throws KettleValueException {
        this.data.agg[0] = null;
        this.step.setMinNullIsValued(false);
        this.step.calcAggregate(new Object[]{null});
        this.step.calcAggregate(new Object[]{2});
        Assert.assertEquals((String)"Min aggregation doesn't properly work if the first value is null", (Object)2, (Object)this.data.agg[0]);
    }

    @Test
    public void getAggregateResultTestMin_0_Test() throws KettleValueException {
        this.step.setAllNullsAreZero(true);
        Object[] row = this.step.getAggregateResult();
        Assert.assertEquals((String)"Default value is not corrupted", (Object)this.def, (Object)row[0]);
    }

    @Test
    public void getAggregateResultTestMin_1_Test() throws KettleValueException {
        this.data.agg[0] = null;
        this.step.setAllNullsAreZero(true);
        Object[] row = this.step.getAggregateResult();
        Assert.assertEquals((String)"Returns 0 if aggregation is null", (Object)new Long(0L), (Object)row[0]);
    }

    @Test
    public void getAggregateResultTestMin_3_Test() throws KettleValueException {
        this.data.agg[0] = null;
        this.step.setAllNullsAreZero(false);
        Object[] row = this.step.getAggregateResult();
        Assert.assertNull((String)"Returns null if aggregation is null", (Object)row[0]);
    }
}

