/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getvariable;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.getvariable.GetVariableMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class GetVariableMetaTest
implements InitializerInterface<GetVariableMeta> {
    LoadSaveTester<GetVariableMeta> loadSaveTester;
    Class<GetVariableMeta> testMetaClass = GetVariableMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
    }

    @Before
    public void setUpLoadSave() throws Exception {
        List<String> attributes = Arrays.asList("fieldDefinitions");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("fieldDefinitions", "getFieldDefinitions");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("fieldDefinitions", "setFieldDefinitions");
        GetVariableMeta.FieldDefinition fieldDefinition = new GetVariableMeta.FieldDefinition();
        fieldDefinition.setFieldName("fieldName");
        fieldDefinition.setFieldLength(4);
        fieldDefinition.setCurrency(null);
        fieldDefinition.setFieldPrecision(5);
        fieldDefinition.setFieldType(1);
        fieldDefinition.setGroup("group");
        fieldDefinition.setVariableString("variableString");
        ArrayLoadSaveValidator<GetVariableMeta.FieldDefinition> fieldDefinitionLoadSaveValidator = new ArrayLoadSaveValidator<GetVariableMeta.FieldDefinition>(new FieldDefinitionLoadSaveValidator(fieldDefinition), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldName", fieldDefinitionLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(GetVariableMeta.FieldDefinition[].class.getCanonicalName(), fieldDefinitionLoadSaveValidator);
        this.loadSaveTester = new LoadSaveTester<GetVariableMeta>(this.testMetaClass, attributes, Collections.emptyList(), Collections.emptyList(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(GetVariableMeta someMeta) {
        someMeta.allocate(5);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testGetValueMetaPlugin() throws KettleStepException {
        GetVariableMeta meta = new GetVariableMeta();
        meta.setDefault();
        GetVariableMeta.FieldDefinition field = new GetVariableMeta.FieldDefinition();
        field.setFieldName("outputField");
        field.setVariableString(String.valueOf(2000000L));
        field.setFieldType(9);
        meta.setFieldDefinitions(new GetVariableMeta.FieldDefinition[]{field});
        RowMeta rowMeta = new RowMeta();
        meta.getFields((RowMetaInterface)rowMeta, "stepName", null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertNotNull((Object)rowMeta);
        Assert.assertEquals((long)1L, (long)rowMeta.size());
        Assert.assertEquals((Object)"outputField", (Object)rowMeta.getFieldNames()[0]);
        Assert.assertEquals((long)9L, (long)rowMeta.getValueMeta(0).getType());
        Assert.assertTrue((boolean)(rowMeta.getValueMeta(0) instanceof ValueMetaTimestamp));
    }

    public static class FieldDefinitionLoadSaveValidator
    implements FieldLoadSaveValidator<GetVariableMeta.FieldDefinition> {
        private final GetVariableMeta.FieldDefinition defaultValue;

        public FieldDefinitionLoadSaveValidator(GetVariableMeta.FieldDefinition defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public GetVariableMeta.FieldDefinition getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(GetVariableMeta.FieldDefinition testObject, Object actual) {
            return EqualsBuilder.reflectionEquals((Object)testObject, (Object)actual);
        }
    }
}

