/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gettablenames;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.gettablenames.GetTableNames;
import org.pentaho.di.trans.steps.gettablenames.GetTableNamesData;
import org.pentaho.di.trans.steps.gettablenames.GetTableNamesMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.powermock.reflect.Whitebox;

public class GetTableNamesTest {
    private StepMockHelper<GetTableNamesMeta, GetTableNamesData> mockHelper;
    private GetTableNames getTableNamesSpy;
    private Database database;
    private GetTableNamesMeta getTableNamesMeta;
    private GetTableNamesData getTableNamesData;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<GetTableNamesMeta, GetTableNamesData>("Get Table Names", GetTableNamesMeta.class, GetTableNamesData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        this.getTableNamesSpy = (GetTableNames)Mockito.spy((Object)new GetTableNames(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
        this.database = (Database)Mockito.mock(Database.class);
        this.getTableNamesMeta = (GetTableNamesMeta)Mockito.mock(GetTableNamesMeta.class);
        this.getTableNamesData = (GetTableNamesData)Mockito.mock(GetTableNamesData.class);
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.cleanUp();
    }

    @Test
    public void processIncludeTableIncludeSchemaTest() throws KettleException {
        this.prepareIncludeTableTest(true);
        this.getTableNamesSpy.processIncludeTable(new Object[]{"", "", "", ""});
        for (String table : this.getTableNamesWithoutSchema()) {
            ((Database)Mockito.verify((Object)this.database)).isSystemTable(table);
            ((Database)Mockito.verify((Object)this.database)).getTableFieldsMeta("schema", table);
        }
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)1))).getTablenames("schema", false);
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)1))).getTablenames("schema", true);
    }

    @Test
    public void processIncludeTableDontIncludeSchemaTest() throws KettleException {
        this.prepareIncludeTableTest(false);
        this.getTableNamesSpy.processIncludeTable(new Object[]{"", "", "", ""});
        for (String table : this.getTableNamesWithoutSchema()) {
            ((Database)Mockito.verify((Object)this.database)).isSystemTable(table);
            ((Database)Mockito.verify((Object)this.database)).getTableFieldsMeta("schema", table);
        }
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)2))).getTablenames("schema", false);
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)0))).getTablenames("schema", true);
    }

    @Test
    public void processIncludeViewIncludesSchemaTest() throws KettleException {
        this.prepareIncludeViewTest(true);
        this.getTableNamesSpy.processIncludeView(new Object[]{"", "", "", ""});
        for (String table : this.getTableNamesWithoutSchema()) {
            ((Database)Mockito.verify((Object)this.database)).isSystemTable(table);
        }
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)1))).getViews("schema", false);
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)1))).getViews("schema", true);
    }

    @Test
    public void processIncludeViewDontIncludeSchemaTest() throws KettleException {
        this.prepareIncludeViewTest(false);
        this.getTableNamesSpy.processIncludeView(new Object[]{"", "", "", ""});
        for (String table : this.getTableNamesWithoutSchema()) {
            ((Database)Mockito.verify((Object)this.database)).isSystemTable(table);
        }
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)2))).getViews("schema", false);
        ((Database)Mockito.verify((Object)this.database, (VerificationMode)Mockito.times((int)0))).getViews("schema", true);
    }

    private void prepareIncludeViewTest(boolean includeSchema) throws KettleException {
        Whitebox.setInternalState((Object)this.getTableNamesSpy, (String)"meta", (Object)this.getTableNamesMeta);
        Whitebox.setInternalState((Object)this.getTableNamesSpy, (String)"data", (Object)this.getTableNamesData);
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"db", (Object)this.database);
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"realSchemaName", (Object)"schema");
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"realIsSystemObjectFieldName", (Object)"Y");
        Mockito.when((Object)this.getTableNamesMeta.isIncludeView()).thenReturn((Object)true);
        Mockito.when((Object)this.getTableNamesMeta.isAddSchemaInOut()).thenReturn((Object)includeSchema);
        Mockito.when((Object)this.database.getViews("schema", true)).thenReturn((Object)this.getTableNamesWithSchema());
        Mockito.when((Object)this.database.getViews("schema", false)).thenReturn((Object)this.getTableNamesWithoutSchema());
    }

    private void prepareIncludeTableTest(boolean includeSchema) throws KettleException {
        Whitebox.setInternalState((Object)this.getTableNamesSpy, (String)"meta", (Object)this.getTableNamesMeta);
        Whitebox.setInternalState((Object)this.getTableNamesSpy, (String)"data", (Object)this.getTableNamesData);
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"db", (Object)this.database);
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"realSchemaName", (Object)"schema");
        Whitebox.setInternalState((Object)this.getTableNamesData, (String)"realIsSystemObjectFieldName", (Object)"Y");
        Mockito.when((Object)this.getTableNamesMeta.isIncludeTable()).thenReturn((Object)true);
        Mockito.when((Object)this.getTableNamesMeta.isAddSchemaInOut()).thenReturn((Object)includeSchema);
        Mockito.when((Object)this.database.getTablenames("schema", true)).thenReturn((Object)this.getTableNamesWithSchema());
        Mockito.when((Object)this.database.getTablenames("schema", false)).thenReturn((Object)this.getTableNamesWithoutSchema());
        Mockito.when((Object)this.database.getCreateTableStatement(Matchers.anyString(), (RowMetaInterface)Matchers.any(), Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)"");
    }

    private String[] getTableNamesWithoutSchema() {
        return new String[]{"table1", "table2", "table3", "table4"};
    }

    private String[] getTableNamesWithSchema() {
        return new String[]{"schema.table1", "schema.table2", "schema.table3", "schema.table4"};
    }
}

