/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getrepositorynames;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNames;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNamesData;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNamesMeta;
import org.pentaho.di.trans.steps.getrepositorynames.ObjectTypeSelection;

public class GetRepositoryNamesTest {
    static Path baseDirName;
    static Repository repo;
    static RepositoryExtended repoExtended;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException, IOException {
        GetRepositoryNamesTest.prepareFileRepository();
        GetRepositoryNamesTest.prepareExtendedRepository();
    }

    private static void prepareFileRepository() throws IOException, KettleException {
        baseDirName = Files.createTempDirectory("GetRepositoryNamesIT", new FileAttribute[0]);
        KettleFileRepositoryMeta repoMeta = new KettleFileRepositoryMeta(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), baseDirName.toString());
        repo = new KettleFileRepository();
        repo.init((RepositoryMeta)repoMeta);
        repo.connect(null, null);
        RepositoryDirectoryInterface rootDir = repo.findDirectory("/");
        RepositoryDirectory subdir1 = new RepositoryDirectory(rootDir, "subdir1");
        repo.saveRepositoryDirectory((RepositoryDirectoryInterface)subdir1);
        TransMeta transMeta1 = new TransMeta();
        transMeta1.setName("Trans1");
        transMeta1.setRepositoryDirectory((RepositoryDirectoryInterface)subdir1);
        repo.save((RepositoryElementInterface)transMeta1, null, null);
        JobMeta jobMeta1 = new JobMeta();
        jobMeta1.setName("Job1");
        jobMeta1.setRepositoryDirectory((RepositoryDirectoryInterface)subdir1);
        repo.save((RepositoryElementInterface)jobMeta1, null, null);
        RepositoryDirectory subdir2 = new RepositoryDirectory((RepositoryDirectoryInterface)subdir1, "subdir2");
        repo.saveRepositoryDirectory((RepositoryDirectoryInterface)subdir2);
        TransMeta transMeta2 = new TransMeta();
        transMeta2.setName("Trans2");
        transMeta2.setRepositoryDirectory((RepositoryDirectoryInterface)subdir2);
        repo.save((RepositoryElementInterface)transMeta2, null, null);
        JobMeta jobMeta2 = new JobMeta();
        jobMeta2.setName("Job2");
        jobMeta2.setRepositoryDirectory((RepositoryDirectoryInterface)subdir2);
        repo.save((RepositoryElementInterface)jobMeta2, null, null);
    }

    private static void prepareExtendedRepository() throws KettleException {
        repoExtended = (RepositoryExtended)Mockito.mock(RepositoryExtended.class);
        Mockito.when((Object)repoExtended.loadRepositoryDirectoryTree(Mockito.anyString(), Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean())).then((Answer)new Answer<RepositoryDirectoryInterface>(){

            public RepositoryDirectoryInterface answer(InvocationOnMock invocation) throws Throwable {
                String actualPath;
                Object[] args = invocation.getArguments();
                RepositoryDirectory root = new RepositoryDirectory();
                root.setName("/");
                RepositoryDirectory subdir1 = new RepositoryDirectory((RepositoryDirectoryInterface)root, "subdir1");
                RepositoryDirectory subdir2 = new RepositoryDirectory((RepositoryDirectoryInterface)subdir1, "subdir2");
                RepositoryObject trans1 = new RepositoryObject(null, "Trans1", (RepositoryDirectoryInterface)subdir1, "user", null, RepositoryObjectType.TRANSFORMATION, "", false);
                RepositoryObject trans2 = new RepositoryObject(null, "Trans2", (RepositoryDirectoryInterface)subdir2, "user", null, RepositoryObjectType.TRANSFORMATION, "", false);
                RepositoryObject job1 = new RepositoryObject(null, "Job1", (RepositoryDirectoryInterface)subdir1, "user", null, RepositoryObjectType.JOB, "", false);
                RepositoryObject job2 = new RepositoryObject(null, "Job2", (RepositoryDirectoryInterface)subdir2, "user", null, RepositoryObjectType.JOB, "", false);
                ArrayList<RepositoryObject> list1 = new ArrayList<RepositoryObject>();
                ArrayList<RepositoryObject> list2 = new ArrayList<RepositoryObject>();
                if (((String)args[1]).contains("ktr")) {
                    list1.add(trans1);
                    list2.add(trans2);
                }
                if (((String)args[1]).contains("kjb")) {
                    list1.add(job1);
                    list2.add(job2);
                }
                subdir1.setRepositoryObjects(list1);
                subdir2.setRepositoryObjects(list2);
                if ((Integer)args[2] == -1) {
                    subdir1.addSubdirectory((RepositoryDirectoryInterface)subdir2);
                    root.addSubdirectory((RepositoryDirectoryInterface)subdir1);
                }
                if ((actualPath = (String)args[0]).equals("/")) {
                    return root;
                }
                if (actualPath.equals(subdir1.getPath())) {
                    return subdir1;
                }
                if (actualPath.equals(subdir2.getPath())) {
                    return subdir2;
                }
                return null;
            }
        });
        IUser user = (IUser)Mockito.mock(IUser.class);
        Mockito.when((Object)user.isAdmin()).thenReturn((Object)true);
        Mockito.when((Object)repoExtended.getUserInfo()).thenReturn((Object)user);
    }

    @AfterClass
    public static void tearDownAfterClass() throws KettleException, IOException {
        if (repo != null) {
            repo.disconnect();
        }
        FileUtils.forceDelete((File)new File(baseDirName.toString()));
    }

    @Test
    public void testGetRepoList_includeSubfolders() throws KettleException {
        this.init(repo, "/", true, ".*", "", ObjectTypeSelection.All, 4);
    }

    @Test
    public void testGetRepoList_excludeSubfolders() throws KettleException {
        this.init(repo, "/", false, ".*", "", ObjectTypeSelection.All, 0);
    }

    @Test
    public void testGetRepoList_transOnly() throws KettleException {
        this.init(repo, "/", true, ".*", "", ObjectTypeSelection.Transformations, 2);
    }

    @Test
    public void testGetRepoList_jobsOnly() throws KettleException {
        this.init(repo, "/", true, ".*", "", ObjectTypeSelection.Jobs, 2);
    }

    @Test
    public void testGetRepoList_nameMask() throws KettleException {
        this.init(repo, "/", true, "Trans.*", "", ObjectTypeSelection.All, 2);
    }

    @Test
    public void testGetRepoList_withoutNameMask() throws KettleException {
        this.init(repo, "/", true, "", "", ObjectTypeSelection.All, 4);
    }

    @Test
    public void testGetRepoList_excludeNameMask() throws KettleException {
        this.init(repo, "/", true, ".*", "Trans1.*", ObjectTypeSelection.All, 3);
    }

    @Test
    public void testGetRepoList_includeSubfolders_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, ".*", "", ObjectTypeSelection.All, 4);
    }

    @Test
    public void testGetRepoList_excludeSubfolders_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", false, ".*", "", ObjectTypeSelection.All, 0);
    }

    @Test
    public void testGetRepoList_transOnly_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, ".*", "", ObjectTypeSelection.Transformations, 2);
    }

    @Test
    public void testGetRepoList_jobsOnly_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, ".*", "", ObjectTypeSelection.Jobs, 2);
    }

    @Test
    public void testGetRepoList_nameMask_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, "Trans.*", "", ObjectTypeSelection.All, 2);
    }

    @Test
    public void testGetRepoList_withoutNameMask_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, "", "", ObjectTypeSelection.All, 4);
    }

    @Test
    public void testGetRepoList_excludeNameMask_Extended() throws KettleException {
        this.init((Repository)repoExtended, "/", true, ".*", "Trans1.*", ObjectTypeSelection.All, 3);
    }

    @Test
    public void testShowHidden() throws KettleException {
        IUser user = (IUser)Mockito.mock(IUser.class);
        Mockito.when((Object)user.isAdmin()).thenReturn((Object)true);
        Mockito.when((Object)repoExtended.getUserInfo()).thenReturn((Object)user);
        this.init((Repository)repoExtended, "/", false, ".*", "", ObjectTypeSelection.All, 0);
        ((RepositoryExtended)Mockito.verify((Object)repoExtended, (VerificationMode)Mockito.never())).loadRepositoryDirectoryTree(Mockito.anyString(), Mockito.anyString(), Mockito.anyInt(), Mockito.eq((boolean)false), Mockito.anyBoolean(), Mockito.anyBoolean());
        Mockito.when((Object)user.isAdmin()).thenReturn((Object)false);
        this.init((Repository)repoExtended, "/", false, ".*", "", ObjectTypeSelection.All, 0);
        ((RepositoryExtended)Mockito.verify((Object)repoExtended)).loadRepositoryDirectoryTree(Mockito.anyString(), Mockito.anyString(), Mockito.anyInt(), Mockito.eq((boolean)false), Mockito.anyBoolean(), Mockito.anyBoolean());
    }

    private void init(Repository repository, String directoryName, boolean includeSubFolders, String nameMask, String exludeNameMask, ObjectTypeSelection typeSelection, int itemCount) throws KettleException {
        Variables vars = new Variables();
        vars.setVariable("DirName", "/subdir1");
        vars.setVariable("IncludeMask", ".*");
        vars.setVariable("ExcludeMask", "");
        GetRepositoryNamesMeta meta = new GetRepositoryNamesMeta();
        meta.setDirectory(new String[]{directoryName});
        meta.setNameMask(new String[]{nameMask});
        meta.setExcludeNameMask(new String[]{exludeNameMask});
        meta.setIncludeSubFolders(new boolean[]{includeSubFolders});
        meta.setObjectTypeSelection(typeSelection);
        StepMeta stepMeta = new StepMeta("GetRepoNamesStep", (StepMetaInterface)meta);
        TransMeta transMeta = new TransMeta((VariableSpace)vars);
        transMeta.setRepository(repository);
        transMeta.addStep(stepMeta);
        GetRepositoryNamesData data = (GetRepositoryNamesData)meta.getStepData();
        GetRepositoryNames step = new GetRepositoryNames(stepMeta, (StepDataInterface)data, 0, transMeta, new Trans(transMeta));
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertNotNull((Object)data.list);
        Assert.assertEquals((long)itemCount, (long)data.list.size());
    }
}

