/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fuzzymatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatch;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatchData;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatchMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class FuzzyMatchTest {
    @InjectMocks
    private FuzzyMatchHandler fuzzyMatch;
    private StepMockHelper<FuzzyMatchMeta, FuzzyMatchData> mockHelper;
    private Object[] row = new Object[]{"Catrine"};
    private Object[] rowB = new Object[]{"Catrine".getBytes()};
    private Object[] row2 = new Object[]{"John"};
    private Object[] row2B = new Object[]{"John".getBytes()};
    private Object[] row3 = new Object[]{"Catriny"};
    private Object[] row3B = new Object[]{"Catriny".getBytes()};
    private List<Object[]> rows = new ArrayList<Object[]>();
    private List<Object[]> binaryRows = new ArrayList<Object[]>();
    private List<Object[]> lookupRows = new ArrayList<Object[]>();
    private List<Object[]> binaryLookupRows = new ArrayList<Object[]>();

    public FuzzyMatchTest() {
        this.rows.add(this.row);
        this.binaryRows.add(this.rowB);
        this.lookupRows.add(this.row2);
        this.lookupRows.add(this.row3);
        this.binaryLookupRows.add(this.row2B);
        this.binaryLookupRows.add(this.row3B);
    }

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<FuzzyMatchMeta, FuzzyMatchData>("Fuzzy Match", FuzzyMatchMeta.class, FuzzyMatchData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testProcessRow() throws Exception {
        this.fuzzyMatch = new FuzzyMatchHandler(this.mockHelper.stepMeta, (StepDataInterface)this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        this.fuzzyMatch.init((StepMetaInterface)this.mockHelper.initStepMetaInterface, (StepDataInterface)this.mockHelper.initStepDataInterface);
        this.fuzzyMatch.addRowSetToInputRowSets(this.mockHelper.getMockInputRowSet(this.rows));
        this.fuzzyMatch.addRowSetToInputRowSets(this.mockHelper.getMockInputRowSet(this.lookupRows));
        Mockito.when((Object)((FuzzyMatchMeta)this.mockHelper.processRowsStepMetaInterface).getAlgorithmType()).thenReturn((Object)8);
        ((FuzzyMatchData)this.mockHelper.processRowsStepDataInterface).look = (HashSet)Mockito.mock(HashSet.class);
        Mockito.when(((FuzzyMatchData)this.mockHelper.processRowsStepDataInterface).look.iterator()).thenReturn(this.lookupRows.iterator());
        this.fuzzyMatch.processRow((StepMetaInterface)this.mockHelper.processRowsStepMetaInterface, (StepDataInterface)this.mockHelper.processRowsStepDataInterface);
        Assert.assertEquals((Object)this.fuzzyMatch.resultRow[0], (Object)this.row3[0]);
    }

    @Test
    public void testReadLookupValues() throws Exception {
        FuzzyMatchData data = (FuzzyMatchData)Mockito.spy((Object)new FuzzyMatchData());
        data.indexOfCachedFields = new int[2];
        data.minimalDistance = 0;
        data.maximalDistance = 5;
        FuzzyMatchMeta meta = (FuzzyMatchMeta)Mockito.spy((Object)new FuzzyMatchMeta());
        meta.setOutputMatchField("I don't want NPE here!");
        data.readLookupValues = true;
        this.fuzzyMatch = new FuzzyMatchHandler(this.mockHelper.stepMeta, (StepDataInterface)this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        this.fuzzyMatch.init((StepMetaInterface)meta, (StepDataInterface)data);
        RowSet lookupRowSet = this.mockHelper.getMockInputRowSet(this.binaryLookupRows);
        this.fuzzyMatch.addRowSetToInputRowSets(this.mockHelper.getMockInputRowSet(this.binaryRows));
        this.fuzzyMatch.addRowSetToInputRowSets(lookupRowSet);
        this.fuzzyMatch.rowset = lookupRowSet;
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("field1");
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("field1"));
        valueMeta.setStorageType(1);
        rowMetaInterface.addValueMeta((ValueMetaInterface)valueMeta);
        Mockito.when((Object)lookupRowSet.getRowMeta()).thenReturn((Object)rowMetaInterface);
        Mockito.when((Object)meta.getLookupField()).thenReturn((Object)"field1");
        Mockito.when((Object)meta.getMainStreamField()).thenReturn((Object)"field1");
        this.fuzzyMatch.setInputRowMeta(rowMetaInterface.clone());
        Mockito.when((Object)meta.getAlgorithmType()).thenReturn((Object)1);
        StepIOMetaInterface stepIOMetaInterface = (StepIOMetaInterface)Mockito.mock(StepIOMetaInterface.class);
        Mockito.when((Object)meta.getStepIOMeta()).thenReturn((Object)stepIOMetaInterface);
        StreamInterface streamInterface = (StreamInterface)Mockito.mock(StreamInterface.class);
        ArrayList<StreamInterface> streamInterfaceList = new ArrayList<StreamInterface>();
        streamInterfaceList.add(streamInterface);
        Mockito.when((Object)streamInterface.getStepMeta()).thenReturn((Object)this.mockHelper.stepMeta);
        Mockito.when((Object)stepIOMetaInterface.getInfoStreams()).thenReturn(streamInterfaceList);
        this.fuzzyMatch.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((Object)rowMetaInterface.getString(this.row3B, 0), (Object)data.outputRowMeta.getString(this.fuzzyMatch.resultRow, 1));
    }

    @Test
    public void testLookupValuesWhenMainFieldIsNull() throws Exception {
        FuzzyMatchData data = (FuzzyMatchData)Mockito.spy((Object)new FuzzyMatchData());
        FuzzyMatchMeta meta = (FuzzyMatchMeta)Mockito.spy((Object)new FuzzyMatchMeta());
        data.readLookupValues = false;
        this.fuzzyMatch = new FuzzyMatchHandler(this.mockHelper.stepMeta, (StepDataInterface)this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        this.fuzzyMatch.init((StepMetaInterface)meta, (StepDataInterface)data);
        this.fuzzyMatch.first = false;
        data.indexOfMainField = 1;
        Object[] inputRow = new Object[]{"test input", null};
        RowSet lookupRowSet = this.mockHelper.getMockInputRowSet(new Object[][]{{"test lookup"}});
        this.fuzzyMatch.addRowSetToInputRowSets(this.mockHelper.getMockInputRowSet(new Object[][]{inputRow}));
        this.fuzzyMatch.addRowSetToInputRowSets(lookupRowSet);
        this.fuzzyMatch.rowset = lookupRowSet;
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("field1");
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("field1"));
        valueMeta.setStorageType(2);
        rowMetaInterface.addValueMeta((ValueMetaInterface)valueMeta);
        Mockito.when((Object)lookupRowSet.getRowMeta()).thenReturn((Object)rowMetaInterface);
        this.fuzzyMatch.setInputRowMeta(rowMetaInterface.clone());
        data.outputRowMeta = rowMetaInterface.clone();
        this.fuzzyMatch.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((Object)inputRow[0], (Object)this.fuzzyMatch.resultRow[0]);
        Assert.assertNull((Object)this.fuzzyMatch.resultRow[1]);
        Assert.assertTrue((boolean)Arrays.stream(this.fuzzyMatch.resultRow, 3, this.fuzzyMatch.resultRow.length).allMatch(val -> val == null));
    }

    private class FuzzyMatchHandler
    extends FuzzyMatch {
        private Object[] resultRow;
        private RowSet rowset;

        public FuzzyMatchHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.resultRow = null;
            this.rowset = null;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.resultRow = row;
        }

        public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
            return this.rowset;
        }
    }
}

