/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fuzzymatch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatchMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class FuzzyMatchMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("value", "valueName", "algorithm", "lookupfield", "mainstreamfield", "outputmatchfield", "outputvaluefield", "caseSensitive", "minimalValue", "maximalValue", "separator", "closervalue");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("value", "getValue");
                this.put("valueName", "getValueName");
                this.put("algorithm", "getAlgorithmType");
                this.put("lookupfield", "getLookupField");
                this.put("mainstreamfield", "getMainStreamField");
                this.put("outputmatchfield", "getOutputMatchField");
                this.put("outputvaluefield", "getOutputValueField");
                this.put("caseSensitive", "isCaseSensitive");
                this.put("minimalValue", "getMinimalValue");
                this.put("maximalValue", "getMaximalValue");
                this.put("separator", "getSeparator");
                this.put("closervalue", "isGetCloserValue");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("value", "setValue");
                this.put("valueName", "setValueName");
                this.put("algorithm", "setAlgorithmType");
                this.put("lookupfield", "setLookupField");
                this.put("mainstreamfield", "setMainStreamField");
                this.put("outputmatchfield", "setOutputMatchField");
                this.put("outputvaluefield", "setOutputValueField");
                this.put("caseSensitive", "setCaseSensitive");
                this.put("minimalValue", "setMinimalValue");
                this.put("maximalValue", "setMaximalValue");
                this.put("separator", "setSeparator");
                this.put("closervalue", "setGetCloserValue");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 3);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("value", stringArrayLoadSaveValidator);
        attrValidatorMap.put("valueName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("algorithm", new AlgorithmLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<FuzzyMatchMeta>(FuzzyMatchMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class AlgorithmLoadSaveValidator
    implements FieldLoadSaveValidator<Integer> {
        final Random rand = new Random();

        @Override
        public Integer getTestObject() {
            return this.rand.nextInt(10);
        }

        @Override
        public boolean validateTestObject(Integer testObject, Object actual) {
            if (!(actual instanceof Integer)) {
                return false;
            }
            Integer actualInt = (Integer)actual;
            return actualInt.equals(testObject);
        }
    }
}

