/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fixedinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;

public class FixedInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<FixedInputMeta> testMetaClass = FixedInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("filename", "headerPresent", "lineWidth", "bufferSize", "lazyConversionActive", "lineFeedPresent", "runningInParallel", "fileType", "addResultFile", "encoding", "fieldDefinition");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldDefinition", new ArrayLoadSaveValidator<FixedFileInputField>(new FixedFileInputFieldLoadSaveValidator(), 5));
        attrValidatorMap.put("fileType", new IntLoadSaveValidator(FixedInputMeta.fileTypeDesc.length));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof FixedInputMeta) {
            ((FixedInputMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class FixedFileInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<FixedFileInputField> {
        final Random rand = new Random();

        @Override
        public FixedFileInputField getTestObject() {
            FixedFileInputField rtn = new FixedFileInputField();
            rtn.setCurrency(UUID.randomUUID().toString());
            rtn.setDecimal(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGrouping(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setLength(this.rand.nextInt(50));
            rtn.setSamples(new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()});
            rtn.setType(this.rand.nextInt(7));
            return rtn;
        }

        @Override
        public boolean validateTestObject(FixedFileInputField testObject, Object actual) {
            if (!(actual instanceof FixedFileInputField)) {
                return false;
            }
            FixedFileInputField actualInput = (FixedFileInputField)actual;
            return testObject.getXML().equals(actualInput.getXML());
        }
    }
}

