/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ConditionLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class FilterRowsMetaTest {
    LoadSaveTester loadSaveTester;
    Class<FilterRowsMeta> testMetaClass = FilterRowsMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("condition", "send_true_to", "send_false_to");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("condition", new ConditionLoadSaveValidator());
        attrValidatorMap.put("trueStepName", new StringLoadSaveValidator());
        attrValidatorMap.put("falseStepname", new StringLoadSaveValidator());
        getterMap.put("send_true_to", "getTrueStepname");
        setterMap.put("send_true_to", "setTrueStepname");
        getterMap.put("send_false_to", "getFalseStepname");
        setterMap.put("send_false_to", "setFalseStepname");
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<FilterRowsMeta>(this.testMetaClass, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testClone() {
        FilterRowsMeta filterRowsMeta = new FilterRowsMeta();
        filterRowsMeta.setCondition(new Condition());
        filterRowsMeta.setTrueStepname("true");
        filterRowsMeta.setFalseStepname("false");
        FilterRowsMeta clone = (FilterRowsMeta)filterRowsMeta.clone();
        Assert.assertNotNull((Object)clone.getCondition());
        Assert.assertEquals((Object)"true", (Object)clone.getTrueStepname());
        Assert.assertEquals((Object)"false", (Object)clone.getFalseStepname());
    }

    @Test
    public void modifiedTarget() throws Exception {
        FilterRowsMeta filterRowsMeta = new FilterRowsMeta();
        StepMeta trueOutput = new StepMeta("true", (StepMetaInterface)new DummyTransMeta());
        StepMeta falseOutput = new StepMeta("false", (StepMetaInterface)new DummyTransMeta());
        filterRowsMeta.setCondition(new Condition());
        filterRowsMeta.setTrueStepname(trueOutput.getName());
        filterRowsMeta.setFalseStepname(falseOutput.getName());
        filterRowsMeta.searchInfoAndTargetSteps((List)ImmutableList.of((Object)trueOutput, (Object)falseOutput));
        trueOutput.setName("true renamed");
        falseOutput.setName("false renamed");
        Assert.assertEquals((Object)"true renamed", (Object)filterRowsMeta.getTrueStepname());
        Assert.assertEquals((Object)"false renamed", (Object)filterRowsMeta.getFalseStepname());
    }
}

