/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;

public class TextFileInputUtilsTest {
    @Test
    public void guessStringsFromLine() throws Exception {
        TextFileInputMeta inputMeta = (TextFileInputMeta)Mockito.mock(TextFileInputMeta.class);
        inputMeta.content = new TextFileInputMeta.Content();
        inputMeta.content.fileType = "CSV";
        String line = "\"\\\\valueA\"|\"valueB\\\\\"|\"val\\\\ueC\"";
        String[] strings = TextFileInputUtils.guessStringsFromLine((VariableSpace)((VariableSpace)Mockito.mock(VariableSpace.class)), (LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)"|", (String)"\"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"\\valueA", (Object)strings[0]);
        Assert.assertEquals((Object)"valueB\\", (Object)strings[1]);
        Assert.assertEquals((Object)"val\\ueC", (Object)strings[2]);
    }

    @Test
    public void convertLineToStrings() throws Exception {
        TextFileInputMeta inputMeta = (TextFileInputMeta)Mockito.mock(TextFileInputMeta.class);
        inputMeta.content = new TextFileInputMeta.Content();
        inputMeta.content.fileType = "CSV";
        inputMeta.inputFields = new BaseFileField[3];
        inputMeta.content.escapeCharacter = "\\";
        String line = "\"\\\\fie\\\\l\\dA\"|\"fieldB\\\\\"|\"fie\\\\ldC\"";
        String[] strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)"|", (String)"\"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"\\fie\\l\\dA", (Object)strings[0]);
        Assert.assertEquals((Object)"fieldB\\", (Object)strings[1]);
        Assert.assertEquals((Object)"fie\\ldC", (Object)strings[2]);
    }

    @Test
    public void convertCSVLinesToStrings() throws Exception {
        TextFileInputMeta inputMeta = (TextFileInputMeta)Mockito.mock(TextFileInputMeta.class);
        inputMeta.content = new TextFileInputMeta.Content();
        inputMeta.content.fileType = "CSV";
        inputMeta.inputFields = new BaseFileField[2];
        inputMeta.content.escapeCharacter = "\\";
        String line = "A\\\\,B";
        String[] strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"A\\", (Object)strings[0]);
        Assert.assertEquals((Object)"B", (Object)strings[1]);
        line = "\\,AB";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)",AB", (Object)strings[0]);
        Assert.assertEquals(null, (Object)strings[1]);
        line = "\\\\\\,AB";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"\\,AB", (Object)strings[0]);
        Assert.assertEquals(null, (Object)strings[1]);
        line = "AB,\\";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"AB", (Object)strings[0]);
        Assert.assertEquals((Object)"\\", (Object)strings[1]);
        line = "AB,\\\\\\";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"AB", (Object)strings[0]);
        Assert.assertEquals((Object)"\\\\", (Object)strings[1]);
        line = "A\\B,C";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"A\\B", (Object)strings[0]);
        Assert.assertEquals((Object)"C", (Object)strings[1]);
    }

    @Test
    public void convertCSVLinesToStringsWithEnclosure() throws Exception {
        TextFileInputMeta inputMeta = (TextFileInputMeta)Mockito.mock(TextFileInputMeta.class);
        inputMeta.content = new TextFileInputMeta.Content();
        inputMeta.content.fileType = "CSV";
        inputMeta.inputFields = new BaseFileField[2];
        inputMeta.content.escapeCharacter = "\\";
        inputMeta.content.enclosure = "\"";
        String line = "\"A\\\\\",\"B\"";
        String[] strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"\"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"A\\", (Object)strings[0]);
        Assert.assertEquals((Object)"B", (Object)strings[1]);
        line = "\"\\\\\",\"AB\"";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"\"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"\\", (Object)strings[0]);
        Assert.assertEquals((Object)"AB", (Object)strings[1]);
        line = "\"A\\B\",\"C\"";
        strings = TextFileInputUtils.convertLineToStrings((LogChannelInterface)((LogChannelInterface)Mockito.mock(LogChannelInterface.class)), (String)line, (TextFileInputMeta)inputMeta, (String)",", (String)"\"", (String)"\\");
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((Object)"A\\B", (Object)strings[0]);
        Assert.assertEquals((Object)"C", (Object)strings[1]);
    }
}

