/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.di.trans.steps.file.IBaseFileInputStepControl;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilter;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilterProcessor;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInput;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputData;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputReader;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;
import org.pentaho.di.utils.TestUtils;

public class TextFileInputTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    private static InputStreamReader getInputStreamReader(String data) throws UnsupportedEncodingException {
        return new InputStreamReader(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    @Test
    public void testGetLineDOS() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r\n";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)0, (StringBuilder)new StringBuilder(1000));
        org.junit.Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineUnix() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\ndata1\tdata2\tdata3\n";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)1, (StringBuilder)new StringBuilder(1000));
        org.junit.Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineOSX() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\rdata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)1, (StringBuilder)new StringBuilder(1000));
        org.junit.Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineMixed() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)2, (StringBuilder)new StringBuilder(1000));
        org.junit.Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test(timeout=100L)
    public void test_PDI695() throws KettleFileException, UnsupportedEncodingException {
        String inputDOS = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r\n";
        String inputUnix = "col1\tcol2\tcol3\ndata1\tdata2\tdata3\n";
        String inputOSX = "col1\tcol2\tcol3\rdata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        org.junit.Assert.assertEquals((Object)expected, (Object)TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputDOS), (int)1, (StringBuilder)new StringBuilder(1000)));
        org.junit.Assert.assertEquals((Object)expected, (Object)TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputUnix), (int)1, (StringBuilder)new StringBuilder(1000)));
        org.junit.Assert.assertEquals((Object)expected, (Object)TextFileInputUtils.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputOSX), (int)1, (StringBuilder)new StringBuilder(1000)));
    }

    @Test
    public void readWrappedInputWithoutHeaders() throws Exception {
        String content = "r1c1" + '\n' + ";r1c2\n" + "r2c1" + '\n' + ";r2c2";
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-2607.txt", content);
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"), TextFileInputTest.field("col2"));
        meta.content.lineWrapped = true;
        meta.content.nrWraps = 1;
        TextFileInputData data = this.createDataObject(virtualFile, ";", "col1", "col2");
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 2, false);
        TransTestingUtil.assertResult(new Object[]{"r1c1", "r1c2"}, output.get(0));
        TransTestingUtil.assertResult(new Object[]{"r2c1", "r2c2"}, output.get(1));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void readInputWithMissedValues() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14172.txt", "1,1,1\n", "2,,2\n");
        BaseFileField field2 = TextFileInputTest.field("col2");
        field2.setRepeated(true);
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"), field2, TextFileInputTest.field("col3"));
        TextFileInputData data = this.createDataObject(virtualFile, ",", "col1", "col2", "col3");
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 2, false);
        TransTestingUtil.assertResult(new Object[]{"1", "1", "1"}, output.get(0));
        TransTestingUtil.assertResult(new Object[]{"2", "1", "2"}, output.get(1));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void readInputWithNonEmptyNullif() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14358.txt", "-,-\n");
        BaseFileField col2 = TextFileInputTest.field("col2");
        col2.setNullString("-");
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"), col2);
        TextFileInputData data = this.createDataObject(virtualFile, ",", "col1", "col2");
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 1, false);
        TransTestingUtil.assertResult(new Object[]{"-"}, output.get(0));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void readInputWithDefaultValues() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14832.txt", "1,\n");
        BaseFileField col2 = TextFileInputTest.field("col2");
        col2.setIfNullValue("DEFAULT");
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"), col2);
        TextFileInputData data = this.createDataObject(virtualFile, ",", "col1", "col2");
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 1, false);
        TransTestingUtil.assertResult(new Object[]{"1", "DEFAULT"}, output.get(0));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void testErrorHandlerLineNumber() throws Exception {
        String content = "123" + '\n' + "333\n" + "345" + '\n' + "773\n" + "aaa" + '\n' + "444";
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-2607.txt", content);
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"));
        meta.inputFields[0].setType(1);
        meta.content.lineWrapped = false;
        meta.content.nrWraps = 1;
        meta.errorHandling.errorIgnored = true;
        TextFileInputData data = this.createDataObject(virtualFile, ";", "col1");
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 4, false);
        ((FileErrorHandler)Mockito.verify((Object)data.dataErrorLineHandler)).handleLineError(4L, "NO_PARTS");
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void testHandleOpenFileException() throws Exception {
        String content = "123" + '\n' + "333\n";
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-16697.txt", content);
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"));
        meta.inputFields[0].setType(1);
        meta.errorHandling.errorIgnored = true;
        meta.errorHandling.skipBadFiles = true;
        TextFileInputData data = this.createDataObject(virtualFile, ";", "col1");
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        TestTextFileInput textFileInput = StepMockUtil.getStep(TestTextFileInput.class, TextFileInputMeta.class, "test");
        StepMeta stepMeta = textFileInput.getStepMeta();
        ((StepMeta)Mockito.doReturn((Object)true).when((Object)stepMeta)).isDoingErrorHandling();
        List<Object[]> output = TransTestingUtil.execute((BaseStep)textFileInput, (StepMetaInterface)meta, (StepDataInterface)data, 0, false);
        TextFileInputTest.deleteVfsFile(virtualFile);
        org.junit.Assert.assertEquals((long)1L, (long)data.rejectedFiles.size());
        org.junit.Assert.assertEquals((long)0L, (long)textFileInput.getErrors());
    }

    @Test
    public void test_PDI17117() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14832.txt", "1,\n");
        BaseFileField col2 = TextFileInputTest.field("col2");
        col2.setIfNullValue("DEFAULT");
        TextFileInputMeta meta = this.createMetaObject(TextFileInputTest.field("col1"), col2);
        meta.inputFiles.passingThruFields = true;
        meta.inputFiles.acceptingFilenames = true;
        TextFileInputData data = this.createDataObject(virtualFile, ",", "col1", "col2");
        TextFileInput input = (TextFileInput)Mockito.spy((Object)StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test"));
        RowSet rowset = (RowSet)Mockito.mock(RowSet.class);
        RowMetaInterface rwi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Object[] obj1 = new Object[2];
        Object[] obj2 = new Object[2];
        ((TextFileInput)Mockito.doReturn((Object)rowset).when((Object)input)).findInputRowSet(null);
        ((TextFileInput)Mockito.doReturn(null).when((Object)input)).getRowFrom(rowset);
        Mockito.when((Object)input.getRowFrom(rowset)).thenReturn((Object)obj1, (Object[])new Object[][]{obj2, null});
        ((RowSet)Mockito.doReturn((Object)rwi).when((Object)rowset)).getRowMeta();
        Mockito.when((Object)rwi.getString(obj2, 0)).thenReturn((Object)"filename1", (Object[])new String[]{"filename2"});
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 0, false);
        ArrayList passThroughKeys = new ArrayList(data.passThruFields.keySet());
        Assert.assertNotNull(passThroughKeys);
        passThroughKeys.sort(String.CASE_INSENSITIVE_ORDER);
        org.junit.Assert.assertEquals((long)2L, (long)passThroughKeys.size());
        Assert.assertNotNull(passThroughKeys.get(0));
        Assert.assertTrue((boolean)((String)passThroughKeys.get(0)).startsWith("0_file"));
        Assert.assertTrue((boolean)((String)passThroughKeys.get(0)).endsWith("filename1"));
        Assert.assertNotNull(passThroughKeys.get(1));
        Assert.assertTrue((boolean)((String)passThroughKeys.get(1)).startsWith("1_file"));
        Assert.assertTrue((boolean)((String)passThroughKeys.get(1)).endsWith("filename2"));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void testClose() throws Exception {
        TextFileInputMeta mockTFIM = this.createMetaObject(null);
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-17267.txt", null);
        TextFileInputData mockTFID = this.createDataObject(virtualFile, ";", null);
        mockTFID.lineBuffer = new ArrayList();
        mockTFID.lineBuffer.add(new TextFileLine(null, 0L, null));
        mockTFID.lineBuffer.add(new TextFileLine(null, 0L, null));
        mockTFID.lineBuffer.add(new TextFileLine(null, 0L, null));
        mockTFID.filename = "";
        FileContent mockFileContent = (FileContent)Mockito.mock(FileContent.class);
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)mockFileContent.getInputStream()).thenReturn((Object)mockInputStream);
        FileObject mockFO = (FileObject)Mockito.mock(FileObject.class);
        Mockito.when((Object)mockFO.getContent()).thenReturn((Object)mockFileContent);
        TextFileInputReader tFIR = new TextFileInputReader((IBaseFileInputStepControl)Mockito.mock(IBaseFileInputStepControl.class), mockTFIM, mockTFID, mockFO, (LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        org.junit.Assert.assertEquals((long)3L, (long)mockTFID.lineBuffer.size());
        tFIR.close();
        org.junit.Assert.assertEquals((long)0L, (long)mockTFID.lineBuffer.size());
    }

    private TextFileInputMeta createMetaObject(BaseFileField ... fields) {
        TextFileInputMeta meta = new TextFileInputMeta();
        meta.content.fileCompression = "None";
        meta.content.fileType = "CSV";
        meta.content.header = false;
        meta.content.nrHeaderLines = -1;
        meta.content.footer = false;
        meta.content.nrFooterLines = -1;
        meta.inputFields = fields;
        return meta;
    }

    private TextFileInputData createDataObject(String file, String separator, String ... outputFields) throws Exception {
        TextFileInputData data = new TextFileInputData();
        data.files = new FileInputList();
        data.files.addFile(KettleVFS.getFileObject((String)file));
        data.separator = separator;
        data.outputRowMeta = new RowMeta();
        if (outputFields != null) {
            for (String field : outputFields) {
                data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(field));
            }
        }
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        data.fileFormatType = 1;
        data.filterProcessor = new TextFileFilterProcessor(new TextFileFilter[0], (VariableSpace)new Variables());
        data.filePlayList = new FilePlayListAll();
        return data;
    }

    private static String createVirtualFile(String filename, String ... rows) throws Exception {
        String virtualFile = TestUtils.createRamFile(filename);
        StringBuilder content = new StringBuilder();
        if (rows != null) {
            for (String row : rows) {
                content.append(row);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(content.toString().getBytes());
        try (OutputStream os = KettleVFS.getFileObject((String)virtualFile).getContent().getOutputStream();){
            IOUtils.copy((InputStream)new ByteArrayInputStream(bos.toByteArray()), (OutputStream)os);
        }
        return virtualFile;
    }

    private static void deleteVfsFile(String path) throws Exception {
        TestUtils.getFileObject(path).delete();
    }

    private static BaseFileField field(String name) {
        return new BaseFileField(name, -1, -1);
    }

    public static class TestTextFileInput
    extends TextFileInput {
        public TestTextFileInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        }

        protected IBaseFileInputReader createReader(TextFileInputMeta meta, TextFileInputData data, FileObject file) throws Exception {
            throw new Exception("Can not create reader for the file object " + file);
        }
    }
}

