/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputFiles;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;

public class TextFileInputMetaTest {
    private static final String FILE_NAME_NULL = null;
    private static final String FILE_NAME_EMPTY = "";
    private static final String FILE_NAME_VALID_PATH = "path/to/file";
    private TextFileInputMeta inputMeta;
    private VariableSpace variableSpace;

    @Before
    public void setUp() throws Exception {
        NamedClusterEmbedManager manager = (NamedClusterEmbedManager)Mockito.mock(NamedClusterEmbedManager.class);
        TransMeta parentTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)manager).when((Object)parentTransMeta)).getNamedClusterEmbedManager();
        StepMeta parentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)parentTransMeta).when((Object)parentStepMeta)).getParentTransMeta();
        this.inputMeta = new TextFileInputMeta();
        this.inputMeta.setParentStepMeta(parentStepMeta);
        this.inputMeta = (TextFileInputMeta)Mockito.spy((Object)this.inputMeta);
        this.variableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        ((VariableSpace)Mockito.doReturn((Object)"<def>").when((Object)this.variableSpace)).environmentSubstitute(Matchers.anyString());
        ((VariableSpace)Mockito.doReturn((Object)FILE_NAME_VALID_PATH).when((Object)this.variableSpace)).environmentSubstitute(FILE_NAME_VALID_PATH);
        FileObject mockedFileObject = (FileObject)Mockito.mock(FileObject.class);
        ((TextFileInputMeta)Mockito.doReturn((Object)mockedFileObject).when((Object)this.inputMeta)).getFileObject(Matchers.anyString(), (VariableSpace)Matchers.eq((Object)this.variableSpace));
    }

    @Test
    public void whenExportingResourcesWeGetFileObjectsOnlyFromFilesWithNotNullAndNotEmptyFileNames() throws Exception {
        this.inputMeta.inputFiles = new BaseFileInputFiles();
        this.inputMeta.inputFiles.fileName = new String[]{FILE_NAME_NULL, FILE_NAME_EMPTY, FILE_NAME_VALID_PATH};
        this.inputMeta.inputFiles.fileMask = new String[]{FILE_NAME_EMPTY, FILE_NAME_EMPTY, FILE_NAME_EMPTY};
        this.inputMeta.exportResources(this.variableSpace, null, (ResourceNamingInterface)Mockito.mock(ResourceNamingInterface.class), null, null);
        ((TextFileInputMeta)Mockito.verify((Object)this.inputMeta)).getFileObject(FILE_NAME_VALID_PATH, this.variableSpace);
        ((TextFileInputMeta)Mockito.verify((Object)this.inputMeta, (VerificationMode)Mockito.never())).getFileObject(FILE_NAME_NULL, this.variableSpace);
        ((TextFileInputMeta)Mockito.verify((Object)this.inputMeta, (VerificationMode)Mockito.never())).getFileObject(FILE_NAME_EMPTY, this.variableSpace);
    }

    @Test
    public void testGetXmlWorksIfWeUpdateOnlyPartOfInputFilesInformation() throws Exception {
        this.inputMeta.inputFiles = new BaseFileInputFiles();
        this.inputMeta.inputFiles.fileName = new String[]{FILE_NAME_VALID_PATH};
        this.inputMeta.getXML();
        Assert.assertEquals((long)this.inputMeta.inputFiles.fileName.length, (long)this.inputMeta.inputFiles.fileMask.length);
        Assert.assertEquals((long)this.inputMeta.inputFiles.fileName.length, (long)this.inputMeta.inputFiles.excludeFileMask.length);
        Assert.assertEquals((long)this.inputMeta.inputFiles.fileName.length, (long)this.inputMeta.inputFiles.fileRequired.length);
        Assert.assertEquals((long)this.inputMeta.inputFiles.fileName.length, (long)this.inputMeta.inputFiles.includeSubFolders.length);
    }

    @Test
    public void testClonelWorksIfWeUpdateOnlyPartOfInputFilesInformation() throws Exception {
        this.inputMeta.inputFiles = new BaseFileInputFiles();
        this.inputMeta.inputFiles.fileName = new String[]{FILE_NAME_VALID_PATH};
        TextFileInputMeta cloned = (TextFileInputMeta)this.inputMeta.clone();
        Assert.assertNotEquals((Object)this.inputMeta, (Object)cloned);
        Assert.assertEquals((long)cloned.inputFiles.fileName.length, (long)this.inputMeta.inputFiles.fileName.length);
        Assert.assertEquals((long)cloned.inputFiles.fileMask.length, (long)this.inputMeta.inputFiles.fileMask.length);
        Assert.assertEquals((long)cloned.inputFiles.excludeFileMask.length, (long)this.inputMeta.inputFiles.excludeFileMask.length);
        Assert.assertEquals((long)cloned.inputFiles.fileRequired.length, (long)this.inputMeta.inputFiles.fileRequired.length);
        Assert.assertEquals((long)cloned.inputFiles.includeSubFolders.length, (long)this.inputMeta.inputFiles.includeSubFolders.length);
        Assert.assertEquals((long)cloned.inputFields.length, (long)this.inputMeta.inputFields.length);
        Assert.assertEquals((long)cloned.getFilter().length, (long)this.inputMeta.getFilter().length);
    }
}

