/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.pentaho.di.trans.steps.file.BaseFileOutputMeta;

public class BaseFileOutputMetaTest {
    @Mock
    BaseFileOutputMeta meta;

    @Before
    public void setup() {
        this.meta = (BaseFileOutputMeta)Mockito.spy(BaseFileOutputMeta.class);
    }

    @Test
    public void testGetFiles() {
        String[] filePaths = this.meta.getFiles("foo", "txt", false);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo.txt", (Object)filePaths[0]);
        filePaths = this.meta.getFiles("foo", "txt", true);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo.txt", (Object)filePaths[0]);
        Mockito.when((Object)this.meta.isStepNrInFilename()).thenReturn((Object)true);
        filePaths = this.meta.getFiles("foo", "txt", false);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo_<step>.txt", (Object)filePaths[0]);
        filePaths = this.meta.getFiles("foo", "txt", true);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)4L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo_0.txt", (Object)filePaths[0]);
        Assert.assertEquals((Object)"foo_1.txt", (Object)filePaths[1]);
        Assert.assertEquals((Object)"foo_2.txt", (Object)filePaths[2]);
        Assert.assertEquals((Object)"...", (Object)filePaths[3]);
        Mockito.when((Object)this.meta.isPartNrInFilename()).thenReturn((Object)true);
        filePaths = this.meta.getFiles("foo", "txt", false);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo_<step>_<partition>.txt", (Object)filePaths[0]);
        Mockito.when((Object)this.meta.getSplitEvery()).thenReturn((Object)1);
        filePaths = this.meta.getFiles("foo", "txt", false);
        Assert.assertNotNull((Object)filePaths);
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"foo_<step>_<partition>_<split>.txt", (Object)filePaths[0]);
    }
}

