/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class FieldSplitter_EmptyStringVsNull_Test {
    private StepMockHelper<FieldSplitterMeta, StepDataInterface> helper;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.helper = StepMockUtil.getStepMockHelper(FieldSplitterMeta.class, "FieldSplitter_EmptyStringVsNull_Test");
    }

    @After
    public void cleanUp() {
        this.helper.cleanUp();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N");
        List<Object[]> expected = Arrays.asList({"a", "", "a"}, {"b", null, "b"}, {null});
        this.executeAndAssertResults(expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "Y");
        List<Object[]> expected = Arrays.asList({"a", "", "a"}, {"b", "", "b"}, {"", "", ""});
        this.executeAndAssertResults(expected);
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        FieldSplitterMeta meta = new FieldSplitterMeta();
        meta.allocate(3);
        meta.setFieldName(new String[]{"s1", "s2", "s3"});
        meta.setFieldType(new int[]{2, 2, 2});
        meta.setSplitField("string");
        meta.setDelimiter(",");
        FieldSplitterData data = new FieldSplitterData();
        FieldSplitter step = this.createAndInitStep(meta, data);
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("string"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (FieldSplitter)Mockito.spy((Object)step);
        ((FieldSplitter)Mockito.doReturn((Object)new String[]{"a, ,a"}).doReturn((Object)new String[]{"b,,b"}).doReturn((Object)new String[]{null}).when((Object)step)).getRow();
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, false);
        TransTestingUtil.assertResult(expected, actual);
    }

    private FieldSplitter createAndInitStep(FieldSplitterMeta meta, FieldSplitterData data) throws Exception {
        Mockito.when((Object)this.helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        FieldSplitter step = new FieldSplitter(this.helper.stepMeta, (StepDataInterface)data, 0, this.helper.transMeta, this.helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

