/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.metastore.api.IMetaStore;

public class FieldSplitterTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    StepMockHelper<FieldSplitterMeta, FieldSplitterData> smh;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<FieldSplitterMeta, FieldSplitterData>("Field Splitter", FieldSplitterMeta.class, FieldSplitterData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void cleanUp() {
        this.smh.cleanUp();
    }

    private RowSet mockInputRowSet() {
        return this.smh.getMockInputRowSet(new Object[][]{{"before", "b=b;c=c", "after"}});
    }

    private FieldSplitterMeta mockProcessRowMeta() throws KettleStepException {
        FieldSplitterMeta processRowMeta = (FieldSplitterMeta)this.smh.processRowsStepMetaInterface;
        ((FieldSplitterMeta)Mockito.doReturn((Object)"field to split").when((Object)processRowMeta)).getSplitField();
        ((FieldSplitterMeta)Mockito.doCallRealMethod().when((Object)processRowMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{"a", "b"}).when((Object)processRowMeta)).getFieldName();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new int[]{2, 2}).when((Object)processRowMeta)).getFieldType();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{"a=", "b="}).when((Object)processRowMeta)).getFieldID();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new boolean[]{false, false}).when((Object)processRowMeta)).getFieldRemoveID();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new int[]{-1, -1}).when((Object)processRowMeta)).getFieldLength();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new int[]{-1, -1}).when((Object)processRowMeta)).getFieldPrecision();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new int[]{0, 0}).when((Object)processRowMeta)).getFieldTrimType();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldFormat();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldDecimal();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldGroup();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldCurrency();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldNullIf();
        ((FieldSplitterMeta)Mockito.doReturn((Object)new String[]{null, null}).when((Object)processRowMeta)).getFieldIfNull();
        ((FieldSplitterMeta)Mockito.doReturn((Object)";").when((Object)processRowMeta)).getDelimiter();
        ((FieldSplitterMeta)Mockito.doReturn((Object)2).when((Object)processRowMeta)).getFieldsCount();
        return processRowMeta;
    }

    private RowMeta getInputRowMeta() {
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("before"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("field to split"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("after"));
        return inputRowMeta;
    }

    @Test
    public void testSplitFields() throws KettleException {
        boolean hasMoreRows;
        FieldSplitter step = new FieldSplitter(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        step.setInputRowMeta((RowMetaInterface)this.getInputRowMeta());
        step.addRowSetToInputRowSets(this.mockInputRowSet());
        step.addRowSetToOutputRowSets((RowSet)new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        Object[] actualRow = outputRowSet.getRow();
        Object[] expectedRow = new Object[]{"before", null, "b=b", "after"};
        Assert.assertEquals((String)"Output row is of an unexpected length", (long)expectedRow.length, (long)outputRowSet.getRowMeta().size());
        for (int i = 0; i < expectedRow.length; ++i) {
            Assert.assertEquals((String)("Unexpected output value at index " + i), (Object)expectedRow[i], (Object)actualRow[i]);
        }
    }

    @Test
    public void testSplitFieldsDup() throws Exception {
        FieldSplitterMeta meta = new FieldSplitterMeta();
        meta.allocate(2);
        meta.setDelimiter(" ");
        meta.setEnclosure("");
        meta.setSplitField("split");
        meta.setFieldName(new String[]{"key", "val"});
        meta.setFieldType(new int[]{2, 2});
        FieldSplitter step = new FieldSplitter(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init((StepMetaInterface)meta, this.smh.stepDataInterface);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("key"));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("val"));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("split"));
        step.setInputRowMeta((RowMetaInterface)rowMeta);
        step.addRowSetToInputRowSets(this.smh.getMockInputRowSet(new Object[][]{{"key", "string", "part1 part2"}}));
        step.addRowSetToOutputRowSets((RowSet)new SingleRowRowSet());
        Assert.assertTrue((boolean)step.processRow((StepMetaInterface)meta, this.smh.stepDataInterface));
        RowSet rs = (RowSet)step.getOutputRowSets().get(0);
        Object[] row = rs.getRow();
        RowMetaInterface rm = rs.getRowMeta();
        Assert.assertArrayEquals((Object[])new Object[]{"key", "string", "part1", "part2"}, (Object[])Arrays.copyOf(row, 4));
        Assert.assertArrayEquals((Object[])new Object[]{"key", "val", "key_1", "val_1"}, (Object[])rm.getFieldNames());
    }
}

