/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class FieldSplitterMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Test
    public void testRoundTrip() throws KettleException {
        List<String> attributes = Arrays.asList("splitfield", "delimiter", "enclosure", "name", "id", "idrem", "type", "format", "group", "decimal", "currency", "length", "precision", "nullif", "ifnull", "trimtype");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("splitfield", "getSplitField");
        getterMap.put("delimiter", "getDelimiter");
        getterMap.put("enclosure", "getEnclosure");
        getterMap.put("name", "getFieldName");
        getterMap.put("id", "getFieldID");
        getterMap.put("idrem", "getFieldRemoveID");
        getterMap.put("type", "getFieldType");
        getterMap.put("format", "getFieldFormat");
        getterMap.put("group", "getFieldGroup");
        getterMap.put("decimal", "getFieldDecimal");
        getterMap.put("currency", "getFieldCurrency");
        getterMap.put("length", "getFieldLength");
        getterMap.put("precision", "getFieldPrecision");
        getterMap.put("nullif", "getFieldNullIf");
        getterMap.put("ifnull", "getFieldIfNull");
        getterMap.put("trimtype", "getFieldTrimType");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("splitfield", "setSplitField");
        setterMap.put("delimiter", "setDelimiter");
        setterMap.put("enclosure", "setEnclosure");
        setterMap.put("name", "setFieldName");
        setterMap.put("id", "setFieldID");
        setterMap.put("idrem", "setFieldRemoveID");
        setterMap.put("type", "setFieldType");
        setterMap.put("format", "setFieldFormat");
        setterMap.put("group", "setFieldGroup");
        setterMap.put("decimal", "setFieldDecimal");
        setterMap.put("currency", "setFieldCurrency");
        setterMap.put("length", "setFieldLength");
        setterMap.put("precision", "setFieldPrecision");
        setterMap.put("nullif", "setFieldNullIf");
        setterMap.put("ifnull", "setFieldIfNull");
        setterMap.put("trimtype", "setFieldTrimType");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        fieldLoadSaveValidatorAttributeMap.put("name", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("id", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("idrem", new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("type", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(ValueMetaFactory.getAllValueMetaNames().length), 5));
        fieldLoadSaveValidatorAttributeMap.put("format", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("group", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("decimal", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("currency", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("length", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("precision", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("nullif", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("ifnull", new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5));
        fieldLoadSaveValidatorAttributeMap.put("trimtype", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(ValueMetaBase.getTrimTypeCodes().length), 5));
        LoadSaveTester<FieldSplitterMeta> loadSaveTester = new LoadSaveTester<FieldSplitterMeta>(FieldSplitterMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testSerialization();
    }

    @Test
    public void postAllocateChange() throws KettleException {
        FieldSplitterMeta meta = new FieldSplitterMeta();
        meta.allocate(0);
        meta.setDelimiter(":");
        meta.setEnclosure("");
        meta.setSplitField("split");
        meta.setFieldName(new String[]{"c1", "c2"});
        meta.getXML();
    }

    @Test
    public void testPDI16559() throws Exception {
        FieldSplitterMeta fieldSplitter = new FieldSplitterMeta();
        fieldSplitter.setFieldName(new String[]{"field1", "field2", "field3", "field4", "field5", "field6", "field7", "field8", "field9", "field10", "field11", "field12"});
        fieldSplitter.setFieldID(new String[]{"fieldID1", "fieldID2", "fieldID3", "fieldID4", "fieldID5", "fieldID6", "fieldID7", "fieldID8", "fieldID9", "fieldID10", "fieldID11"});
        fieldSplitter.setFieldRemoveID(new boolean[]{true, false, false, false, false, false, true, false, true});
        fieldSplitter.setFieldFormat(new String[]{"asdf", "asdf", "qwer", "qwer", "QErasdf", "zxvv", "fasdf", "qwerqwr"});
        fieldSplitter.setFieldGroup(new String[]{"groupa", "groupb", "groupa", "groupb", "groupa", "groupb", "groupa", "groupb"});
        fieldSplitter.setFieldDecimal(new String[]{"asdf", "qwer", "zxcvb", "erty", "asfaf", "fhdfhg"});
        fieldSplitter.setFieldCurrency(new String[]{"$", "$", "$", "$", "$", "$"});
        fieldSplitter.setFieldLength(new int[]{12, 6, 15, 14, 23, 177, 13, 21});
        fieldSplitter.setFieldPrecision(new int[]{7, 7, 7, 7, 12, 16, 5, 5, 5});
        fieldSplitter.setFieldNullIf(new String[]{"hdfgh", "sdfgsdg", "ZZfZDf", "dfhfh", "235gwst", "qreqwre"});
        fieldSplitter.setFieldIfNull(new String[]{"asdfsaf", "qwreqwr", "afxxvzxvc", "qwreasgf", "zxcgdfg"});
        fieldSplitter.setFieldTrimType(new int[]{1, 0, 2});
        fieldSplitter.setFieldType(new int[]{1, 1, 0, 3});
        try {
            String badXml = fieldSplitter.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        fieldSplitter.afterInjectionSynchronization();
        String ktrXml = fieldSplitter.getXML();
        int targetSz = fieldSplitter.getFieldName().length;
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldID().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldRemoveID().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldFormat().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldGroup().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldDecimal().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldCurrency().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldLength().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldPrecision().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldNullIf().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldIfNull().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldType().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldTrimType().length);
        fieldSplitter.setFieldType(null);
        fieldSplitter.setFieldRemoveID(null);
        fieldSplitter.setFieldID(null);
        fieldSplitter.afterInjectionSynchronization();
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldType().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldID().length);
        Assert.assertEquals((long)targetSz, (long)fieldSplitter.getFieldRemoveID().length);
    }
}

