/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStep;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepField;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ExcelWriterStep_StyleFormatTest {
    private StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData> stepMockHelper;
    private ExcelWriterStep step;
    private ExcelWriterStepMeta stepMeta;
    private ExcelWriterStepData stepData;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData>("Excel Writer Style Format Test", ExcelWriterStepMeta.class, ExcelWriterStepData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString());
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Object[])Matchers.any(Object[].class));
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Throwable)Matchers.anyObject());
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.stepData.file = null;
        this.stepData.sheet = null;
        this.stepData.wb = null;
        this.stepData.clearStyleCache(0);
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testStyleFormatHssf() throws Exception {
        this.testStyleFormat("xls");
    }

    @Test
    public void testStyleFormatXssf() throws Exception {
        this.testStyleFormat("xlsx");
    }

    private void testStyleFormat(String fileType) throws Exception {
        this.setupStepMock(fileType);
        this.createStepMeta(fileType);
        this.createStepData(fileType);
        this.step.init((StepMetaInterface)this.stepMeta, (StepDataInterface)this.stepData);
        ArrayList<Object[]> rows = this.createRowData();
        for (int i = 0; i < rows.size(); ++i) {
            this.step.writeNextLine((Object[])rows.get(i));
        }
        Row xlsRow = this.stepData.sheet.getRow(0);
        Cell baseCell = xlsRow.getCell(6);
        CellStyle baseCellStyle = baseCell.getCellStyle();
        DataFormat format = this.stepData.wb.createDataFormat();
        xlsRow = this.stepData.sheet.getRow(2);
        for (int i = 0; i < this.stepData.inputRowMeta.size(); ++i) {
            Cell cell = xlsRow.getCell(i);
            CellStyle cellStyle = cell.getCellStyle();
            if (i > 0) {
                Assert.assertEquals((long)cellStyle.getBorderRight(), (long)baseCellStyle.getBorderRight());
                Assert.assertEquals((long)cellStyle.getFillPattern(), (long)baseCellStyle.getFillPattern());
            } else {
                Assert.assertFalse((cellStyle.getBorderRight() == baseCellStyle.getBorderRight() ? 1 : 0) != 0);
                Assert.assertFalse((cellStyle.getFillPattern() == baseCellStyle.getFillPattern() ? 1 : 0) != 0);
            }
            if (i != 1) {
                Assert.assertEquals((Object)format.getFormat(cellStyle.getDataFormat()), (Object)"0.00000");
                continue;
            }
            Assert.assertEquals((Object)format.getFormat(cellStyle.getDataFormat()), (Object)"##0,000.0");
        }
    }

    private void createStepMeta(String fileType) throws KettleException {
        this.stepMeta = new ExcelWriterStepMeta();
        this.stepMeta.setDefault();
        this.stepMeta.setFileName("testExcel");
        this.stepMeta.setExtension(fileType);
        this.stepMeta.setSheetname("Sheet1");
        this.stepMeta.setHeaderEnabled(true);
        this.stepMeta.setStartingCell("A2");
        ExcelWriterStepField[] outputFields = new ExcelWriterStepField[4];
        outputFields[0] = new ExcelWriterStepField("col 1", ValueMetaFactory.getIdForValueMeta((String)"Integer"), "0.00000");
        outputFields[0].setStyleCell("");
        outputFields[1] = new ExcelWriterStepField("col 2", ValueMetaFactory.getIdForValueMeta((String)"Number"), "");
        outputFields[1].setStyleCell("G1");
        outputFields[2] = new ExcelWriterStepField("col 3", ValueMetaFactory.getIdForValueMeta((String)"BigNumber"), "0.00000");
        outputFields[2].setStyleCell("F1");
        outputFields[3] = new ExcelWriterStepField("col 4", ValueMetaFactory.getIdForValueMeta((String)"Integer"), "0.00000");
        outputFields[3].setStyleCell("G1");
        this.stepMeta.setOutputFields(outputFields);
    }

    private void createStepData(String fileType) throws KettleException {
        this.stepData = new ExcelWriterStepData();
        this.stepData.inputRowMeta = this.step.getInputRowMeta().clone();
        this.stepData.outputRowMeta = this.step.getInputRowMeta().clone();
        CellReference cellRef = new CellReference(this.stepMeta.getStartingCell());
        this.stepData.startingRow = cellRef.getRow();
        this.stepData.posX = this.stepData.startingCol = (int)cellRef.getCol();
        this.stepData.posY = this.stepData.startingRow;
        int numOfFields = this.stepData.inputRowMeta.size();
        this.stepData.fieldnrs = new int[numOfFields];
        this.stepData.linkfieldnrs = new int[numOfFields];
        this.stepData.commentfieldnrs = new int[numOfFields];
        for (int i = 0; i < numOfFields; ++i) {
            this.stepData.fieldnrs[i] = i;
            this.stepData.linkfieldnrs[i] = -1;
            this.stepData.commentfieldnrs[i] = -1;
        }
        this.stepData.wb = this.stepMeta.getExtension().equalsIgnoreCase("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        this.stepData.sheet = this.stepData.wb.createSheet();
        this.stepData.file = null;
        this.stepData.clearStyleCache(numOfFields);
        DataFormat format = this.stepData.wb.createDataFormat();
        Row xlsRow = this.stepData.sheet.createRow(0);
        Cell cell = xlsRow.createCell(5);
        CellStyle cellStyle = this.stepData.wb.createCellStyle();
        cellStyle.setBorderRight(BorderStyle.THICK);
        cellStyle.setFillPattern(FillPatternType.FINE_DOTS);
        cell.setCellStyle(cellStyle);
        cellStyle = this.stepData.wb.createCellStyle();
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        cell = xlsRow.createCell(6);
        cellStyle.setDataFormat(format.getFormat("##0,000.0"));
        cell.setCellStyle(cellStyle);
    }

    private void setupStepMock(String fileType) throws Exception {
        this.step = new ExcelWriterStep(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.step.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        ArrayList<Object[]> rows = this.createRowData();
        String[] outFields = new String[]{"col 1", "col 2", "col 3", "col 4"};
        RowSet inputRowSet = this.stepMockHelper.getMockInputRowSet(rows);
        RowMetaInterface inputRowMeta = this.createRowMeta();
        inputRowSet.setRowMeta(inputRowMeta);
        RowMetaInterface mockOutputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)mockOutputRowMeta.size()).thenReturn((Object)outFields.length);
        Mockito.when((Object)inputRowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        this.step.addRowSetToInputRowSets(inputRowSet);
        this.step.setInputRowMeta(inputRowMeta);
        this.step.addRowSetToOutputRowSets(inputRowSet);
    }

    private ArrayList<Object[]> createRowData() throws Exception {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] row = new Object[]{new Long(123456L), new Double(2.34E-4), new BigDecimal("123456789.987654321"), new Double(504150.0)};
        rows.add(row);
        row = new Object[]{new Long(1001001L), new Double(4.6789E10), new BigDecimal(1231.23), new Double(1.23123E7)};
        rows.add(row);
        return rows;
    }

    private RowMetaInterface createRowMeta() throws KettleException {
        RowMeta rm = new RowMeta();
        try {
            ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMetaInteger("col 1"), new ValueMetaNumber("col 2"), new ValueMetaBigNumber("col 3"), new ValueMetaNumber("col 4")};
            for (int i = 0; i < valuesMeta.length; ++i) {
                rm.addValueMeta(valuesMeta[i]);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return rm;
    }
}

