/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStep;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ExcelWriterStep_FormulaRecalculationTest {
    private ExcelWriterStep step;
    private ExcelWriterStepData data;
    private StepMockHelper<ExcelWriterStepMeta, StepDataInterface> mockHelper;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = StepMockUtil.getStepMockHelper(ExcelWriterStepMeta.class, "ExcelWriterStep_FormulaRecalculationTest");
        this.step = new ExcelWriterStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        this.step = (ExcelWriterStep)Mockito.spy((Object)this.step);
        ((ExcelWriterStep)Mockito.doNothing().when((Object)this.step)).prepareNextOutputFile();
        this.data = new ExcelWriterStepData();
        this.step.init(this.mockHelper.initStepMetaInterface, (StepDataInterface)this.data);
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void forcesToRecalculate_Sxssf_PropertyIsSet() throws Exception {
        this.forcesToRecalculate_Sxssf("Y", true);
    }

    @Test
    public void forcesToRecalculate_Sxssf_PropertyIsCleared() throws Exception {
        this.forcesToRecalculate_Sxssf("N", false);
    }

    @Test
    public void forcesToRecalculate_Sxssf_PropertyIsNotSet() throws Exception {
        this.forcesToRecalculate_Sxssf(null, false);
    }

    private void forcesToRecalculate_Sxssf(String property, boolean expectedFlag) throws Exception {
        this.step.setVariable("KETTLE_EXCEL_WRITER_STREAMER_FORCE_RECALCULATE", property);
        this.data.wb = (Workbook)Mockito.spy((Object)new SXSSFWorkbook());
        this.step.recalculateAllWorkbookFormulas();
        if (expectedFlag) {
            ((Workbook)Mockito.verify((Object)this.data.wb)).setForceFormulaRecalculation(true);
        } else {
            ((Workbook)Mockito.verify((Object)this.data.wb, (VerificationMode)Mockito.never())).setForceFormulaRecalculation(Mockito.anyBoolean());
        }
    }

    @Test
    public void forcesToRecalculate_Hssf() throws Exception {
        this.data.wb = new HSSFWorkbook();
        this.data.wb.createSheet("sheet1");
        this.data.wb.createSheet("sheet2");
        this.step.recalculateAllWorkbookFormulas();
        if (!this.data.wb.getForceFormulaRecalculation()) {
            int sheets = this.data.wb.getNumberOfSheets();
            for (int i = 0; i < sheets; ++i) {
                Sheet sheet = this.data.wb.getSheetAt(i);
                Assert.assertTrue((String)("Sheet #" + i + ": " + sheet.getSheetName()), (boolean)sheet.getForceFormulaRecalculation());
            }
        }
    }
}

