/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import com.google.common.io.Files;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStep;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepField;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.utils.TestUtils;

public class ExcelWriterStepTest {
    private static final String SHEET_NAME = "Sheet1";
    private static final String XLSX = "xlsx";
    private static final String DOT_XLSX = ".xlsx";
    private static final String EMPTY_STRING = "";
    private Workbook wb;
    private StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData> mockHelper;
    private ExcelWriterStep step;
    private ExcelWriterStepMeta stepMeta;
    private ExcelWriterStepMeta metaMock;
    private ExcelWriterStepData dataMock;

    @Before
    public void setUp() throws Exception {
        String path = TestUtils.createRamFile(this.getClass().getSimpleName() + "/testXLSProtect.xls");
        FileObject xlsFile = TestUtils.getFileObject(path);
        this.wb = this.createWorkbook(xlsFile);
        this.mockHelper = new StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData>("Excel Writer Test", ExcelWriterStepMeta.class, ExcelWriterStepData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        this.step = (ExcelWriterStep)Mockito.spy((Object)new ExcelWriterStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
        this.stepMeta = new ExcelWriterStepMeta();
        this.metaMock = (ExcelWriterStepMeta)Mockito.mock(ExcelWriterStepMeta.class);
        this.dataMock = (ExcelWriterStepData)Mockito.mock(ExcelWriterStepData.class);
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testProtectSheet() throws Exception {
        this.step.protectSheet(this.wb.getSheet(SHEET_NAME), "aa");
        Assert.assertTrue((boolean)this.wb.getSheet(SHEET_NAME).getProtect());
    }

    @Test
    public void testMaxSheetNameLength() {
        Mockito.when((Object)((ExcelWriterStepMeta)this.mockHelper.initStepMetaInterface).getSheetname()).thenReturn((Object)"12345678901234567890123456789012");
        this.step.init(this.mockHelper.initStepMetaInterface, this.mockHelper.initStepDataInterface);
        try {
            this.step.prepareNextOutputFile();
            Assert.fail();
        }
        catch (KettleException e) {
            String content = e.getMessage();
            Assert.assertTrue((boolean)content.contains("12345678901234567890123456789012"));
        }
    }

    @Test
    public void testTopLevelMetadataEntries() throws Exception {
        List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
        String masterKeys = "FIELDS";
        for (StepInjectionMetaEntry entry : entries) {
            String key = entry.getKey();
            Assert.assertTrue((boolean)masterKeys.contains(key));
            masterKeys = masterKeys.replace(key, EMPTY_STRING);
        }
        Assert.assertEquals((long)0L, (long)masterKeys.trim().length());
    }

    @Test
    public void testChildLevelMetadataEntries() throws Exception {
        List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
        StepInjectionMetaEntry mappingEntry = null;
        String childKeys = "NAME TYPE FORMAT STYLECELL FIELDTITLE TITLESTYLE FORMULA HYPERLINKFIELD CELLCOMMENT COMMENTAUTHOR";
        for (StepInjectionMetaEntry entry : entries) {
            String key = entry.getKey();
            if (!key.equals("FIELDS")) continue;
            mappingEntry = entry;
            break;
        }
        Assert.assertNotNull(mappingEntry);
        List fieldAttributes = ((StepInjectionMetaEntry)mappingEntry.getDetails().get(0)).getDetails();
        for (StepInjectionMetaEntry attribute : fieldAttributes) {
            String key = attribute.getKey();
            Assert.assertTrue((boolean)childKeys.contains(key));
            childKeys = childKeys.replace(key, EMPTY_STRING);
        }
        Assert.assertEquals((long)0L, (long)childKeys.trim().length());
    }

    @Test
    public void testInjection() throws Exception {
        List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
        for (StepInjectionMetaEntry entry : entries) {
            switch (entry.getValueType()) {
                case 2: {
                    entry.setValue((Object)"new_".concat(entry.getKey()));
                    break;
                }
                case 4: {
                    entry.setValue((Object)Boolean.TRUE);
                    break;
                }
            }
            if (entry.getDetails().isEmpty()) continue;
            List childEntries = ((StepInjectionMetaEntry)entry.getDetails().get(0)).getDetails();
            for (StepInjectionMetaEntry childEntry : childEntries) {
                switch (childEntry.getValueType()) {
                    case 2: {
                        childEntry.setValue((Object)"new_".concat(childEntry.getKey()));
                        break;
                    }
                    case 4: {
                        childEntry.setValue((Object)Boolean.TRUE);
                        break;
                    }
                }
            }
        }
        this.stepMeta.getStepMetaInjectionInterface().injectStepMetadataEntries(entries);
        Assert.assertEquals((String)"Cell comment not properly injected... ", (Object)"new_CELLCOMMENT", (Object)this.stepMeta.getOutputFields()[0].getCommentField());
        Assert.assertEquals((String)"Format not properly injected... ", (Object)"new_FORMAT", (Object)this.stepMeta.getOutputFields()[0].getFormat());
        Assert.assertEquals((String)"Hyperlink not properly injected... ", (Object)"new_HYPERLINKFIELD", (Object)this.stepMeta.getOutputFields()[0].getHyperlinkField());
        Assert.assertEquals((String)"Name not properly injected... ", (Object)"new_NAME", (Object)this.stepMeta.getOutputFields()[0].getName());
        Assert.assertEquals((String)"Style cell not properly injected... ", (Object)"new_STYLECELL", (Object)this.stepMeta.getOutputFields()[0].getStyleCell());
        Assert.assertEquals((String)"Title not properly injected... ", (Object)"new_FIELDTITLE", (Object)this.stepMeta.getOutputFields()[0].getTitle());
        Assert.assertEquals((String)"Title style cell not properly injected... ", (Object)"new_TITLESTYLE", (Object)this.stepMeta.getOutputFields()[0].getTitleStyleCell());
        Assert.assertEquals((String)"Type not properly injected... ", (long)0L, (long)this.stepMeta.getOutputFields()[0].getType());
        Assert.assertEquals((String)"Comment author not properly injected... ", (Object)"new_COMMENTAUTHOR", (Object)this.stepMeta.getOutputFields()[0].getCommentAuthorField());
    }

    @Test
    public void testPrepareNextOutputFile() throws Exception {
        Assert.assertTrue((boolean)this.step.init((StepMetaInterface)this.metaMock, (StepDataInterface)this.dataMock));
        File outDir = Files.createTempDir();
        String testFileOut = outDir.getAbsolutePath() + File.separator + "test.xlsx";
        Mockito.when((Object)this.step.buildFilename(0)).thenReturn((Object)testFileOut);
        Mockito.when((Object)this.metaMock.isTemplateEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.metaMock.isStreamingData()).thenReturn((Object)true);
        Mockito.when((Object)this.metaMock.isHeaderEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.metaMock.getExtension()).thenReturn((Object)XLSX);
        this.dataMock.createNewFile = true;
        this.dataMock.realTemplateFileName = this.getClass().getResource("template_test.xlsx").getFile();
        this.dataMock.realSheetname = SHEET_NAME;
        this.step.prepareNextOutputFile();
    }

    @Test
    public void testWriteUsingTemplateWithFormatting() throws Exception {
        Assert.assertTrue((boolean)this.step.init((StepMetaInterface)this.metaMock, (StepDataInterface)this.dataMock));
        String path = Files.createTempDir().getAbsolutePath() + File.separator + "formatted.xlsx";
        this.dataMock.fieldnrs = new int[]{0};
        this.dataMock.linkfieldnrs = new int[]{-1};
        this.dataMock.commentfieldnrs = new int[]{-1};
        this.dataMock.createNewFile = true;
        this.dataMock.realTemplateFileName = this.getClass().getResource("template_with_formatting.xlsx").getFile();
        this.dataMock.realSheetname = "TicketData";
        this.dataMock.inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ExcelWriterStepField field = new ExcelWriterStepField();
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaInteger.class);
        ((ValueMetaInterface)Mockito.doReturn((Object)5).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"name").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)12.0).when((Object)vmi)).getNumber(Matchers.anyObject());
        ((ExcelWriterStep)Mockito.doReturn((Object)path).when((Object)this.step)).buildFilename(0);
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)true).when((Object)this.metaMock)).isTemplateEnabled();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)true).when((Object)this.metaMock)).isStreamingData();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)false).when((Object)this.metaMock)).isHeaderEnabled();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)XLSX).when((Object)this.metaMock)).getExtension();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)new ExcelWriterStepField[]{field}).when((Object)this.metaMock)).getOutputFields();
        ((RowMetaInterface)Mockito.doReturn((Object)10).when((Object)this.dataMock.inputRowMeta)).size();
        ((RowMetaInterface)Mockito.doReturn((Object)vmi).when((Object)this.dataMock.inputRowMeta)).getValueMeta(Matchers.anyInt());
        this.step.prepareNextOutputFile();
        this.dataMock.posY = 1;
        this.dataMock.sheet = (Sheet)Mockito.spy((Object)this.dataMock.sheet);
        this.step.writeNextLine(new Object[]{12});
        ((Sheet)Mockito.verify((Object)this.dataMock.sheet, (VerificationMode)Mockito.times((int)0))).createRow(1);
        ((Sheet)Mockito.verify((Object)this.dataMock.sheet)).getRow(1);
    }

    @Test
    public void testValueBigNumber() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaBigNumber.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)6).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_bigNumber").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)Double.MAX_VALUE).when((Object)vmi)).getNumber(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueBinary() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaBinary.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)8).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_binary").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)"a1b2c3d4e5f6g7h8i9j0").when((Object)vmi)).getString(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueBoolean() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaInteger.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)4).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_bool").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)Boolean.FALSE).when((Object)vmi)).getBoolean(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueDate() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaDate.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)3).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_date").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)new Date()).when((Object)vmi)).getDate(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueInteger() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaInteger.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)5).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_integer").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)Double.MAX_VALUE).when((Object)vmi)).getNumber(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueInternetAddress() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaInternetAddress.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)10).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_internetAddress").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)"127.0.0.1").when((Object)vmi)).getString(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueNumber() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaNumber.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)1).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_number").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)Double.MIN_VALUE).when((Object)vmi)).getNumber(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueString() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaString.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)2).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_string").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)"a_string").when((Object)vmi)).getString(Matchers.anyObject());
        this.testValue_Template(vmi, vObj);
    }

    @Test
    public void testValueTimestamp() throws Exception {
        ValueMetaInterface vmi = (ValueMetaInterface)Mockito.mock(ValueMetaTimestamp.class, (Answer)new DefaultAnswerThrowsException());
        Object vObj = new Object();
        ((ValueMetaInterface)Mockito.doReturn((Object)10).when((Object)vmi)).getType();
        ((ValueMetaInterface)Mockito.doReturn((Object)"value_timestamp").when((Object)vmi)).getName();
        ((ValueMetaInterface)Mockito.doReturn((Object)"127.0.0.1").when((Object)vmi)).getString(vObj);
        this.testValue_Template(vmi, vObj);
    }

    private void testValue_Template(ValueMetaInterface vmi, Object vObj) throws Exception {
        Object[] vObjArr = new Object[]{vObj};
        Assert.assertTrue((boolean)this.step.init((StepMetaInterface)this.metaMock, (StepDataInterface)this.dataMock));
        File tempFile = File.createTempFile(XLSX, DOT_XLSX);
        tempFile.deleteOnExit();
        String path = tempFile.getAbsolutePath();
        this.dataMock.fieldnrs = new int[]{0};
        this.dataMock.linkfieldnrs = new int[]{-1};
        this.dataMock.commentfieldnrs = new int[]{-1};
        this.dataMock.createNewFile = true;
        this.dataMock.realSheetname = SHEET_NAME;
        this.dataMock.inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((ExcelWriterStep)Mockito.doReturn((Object)path).when((Object)this.step)).buildFilename(0);
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)false).when((Object)this.metaMock)).isTemplateEnabled();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)false).when((Object)this.metaMock)).isStreamingData();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)false).when((Object)this.metaMock)).isHeaderEnabled();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)XLSX).when((Object)this.metaMock)).getExtension();
        ExcelWriterStepField field = new ExcelWriterStepField();
        ((ExcelWriterStepMeta)Mockito.doReturn((Object)new ExcelWriterStepField[]{field}).when((Object)this.metaMock)).getOutputFields();
        ((RowMetaInterface)Mockito.doReturn((Object)1).when((Object)this.dataMock.inputRowMeta)).size();
        ((RowMetaInterface)Mockito.doReturn((Object)vmi).when((Object)this.dataMock.inputRowMeta)).getValueMeta(Matchers.anyInt());
        this.step.prepareNextOutputFile();
        this.dataMock.posY = 1;
        this.dataMock.sheet = (Sheet)Mockito.spy((Object)this.dataMock.sheet);
        this.step.writeNextLine(vObjArr);
        ((ExcelWriterStep)Mockito.verify((Object)this.step)).writeField(Matchers.eq((Object)vObj), (ValueMetaInterface)Matchers.eq((Object)vmi), (ExcelWriterStepField)Matchers.eq((Object)field), (Row)Matchers.any(Row.class), Matchers.eq((int)0), (Object[])Matchers.any(), Matchers.eq((int)0), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((Sheet)Mockito.verify((Object)this.dataMock.sheet)).createRow(Matchers.anyInt());
        ((Sheet)Mockito.verify((Object)this.dataMock.sheet)).getRow(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook createWorkbook(FileObject file) throws Exception {
        HSSFWorkbook wb = null;
        OutputStream os = null;
        try {
            os = file.getContent().getOutputStream();
            wb = new HSSFWorkbook();
            wb.createSheet(SHEET_NAME);
            wb.write(os);
        }
        finally {
            os.flush();
            os.close();
        }
        return wb;
    }

    private static class DefaultAnswerThrowsException
    implements Answer<Object> {
        private DefaultAnswerThrowsException() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            throw new RuntimeException("This method (" + invocation.getMethod() + ") shouldn't have been called.");
        }
    }
}

