/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import jxl.Workbook;
import jxl.write.WritableCellFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutput;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ExcelOutputTest {
    public static final String CREATED_SHEET_NAME = "Sheet1";
    private static StepMockHelper<ExcelOutputMeta, ExcelOutputData> helper;
    @ClassRule
    public static RestorePDIEngineEnvironment env;

    @BeforeClass
    public static void setUp() throws KettleException {
        KettleEnvironment.init();
        helper = new StepMockHelper<ExcelOutputMeta, ExcelOutputData>("ExcelOutputTest", ExcelOutputMeta.class, ExcelOutputData.class);
        Mockito.when((Object)ExcelOutputTest.helper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)ExcelOutputTest.helper.logChannelInterface);
        Mockito.when((Object)ExcelOutputTest.helper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        helper.cleanUp();
    }

    private String buildFilePath() throws IOException {
        File outFile = File.createTempFile("aaa", ".xls");
        String fileFullPath = outFile.getCanonicalPath();
        outFile.delete();
        return fileFullPath;
    }

    private ExcelOutputMeta createStepMeta(String fileName, String templateFullPath, boolean isAppend) throws IOException {
        ExcelOutputMeta meta = new ExcelOutputMeta();
        meta.setFileName(fileName);
        if (null == templateFullPath) {
            meta.setTemplateEnabled(false);
        } else {
            meta.setTemplateEnabled(true);
            meta.setTemplateFileName(templateFullPath);
        }
        meta.setAppend(isAppend);
        ExcelField[] excelFields = new ExcelField[]{new ExcelField("f1", 1, null), new ExcelField("f2", 2, null)};
        meta.setOutputFields(excelFields);
        return meta;
    }

    @Test
    public void testExceptionClosingWorkbook() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, null, true);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)1L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)2L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void testClosingFile() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        String testColumnName = "testColumnName";
        data.formats.put(testColumnName, new WritableCellFormat());
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        ((ExcelOutput)Mockito.doReturn((Object)1L).when((Object)excelOutput)).getLinesOutput();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, null, true);
        meta.setSplitEvery(1);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertNull(data.formats.get(testColumnName));
    }

    @Test
    public void test_AppendNoTemplate() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, null, true);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)1L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)4L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void test_NoAppendNoTemplate() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, null, false);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)1L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)1L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void test_AppendTemplate() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        URL excelTemplateResource = this.getClass().getResource("excel-template.xls");
        String templateFullPath = excelTemplateResource.getFile();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, templateFullPath, true);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)3L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)4L, (long)workbook.getSheet("SheetA").getRows());
        Assert.assertEquals((long)5L, (long)workbook.getSheet("SheetB").getRows());
        Assert.assertEquals((long)4L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void test_NoAppendTemplate() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        URL excelTemplateResource = this.getClass().getResource("excel-template.xls");
        String templateFullPath = excelTemplateResource.getFile();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, templateFullPath, false);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)3L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)4L, (long)workbook.getSheet("SheetA").getRows());
        Assert.assertEquals((long)5L, (long)workbook.getSheet("SheetB").getRows());
        Assert.assertEquals((long)1L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void test_AppendTemplateWithSheet1() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        URL excelTemplateResource = this.getClass().getResource("excel-template-withSheet1.xls");
        String templateFullPath = excelTemplateResource.getFile();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, templateFullPath, true);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)3L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)4L, (long)workbook.getSheet("SheetA").getRows());
        Assert.assertEquals((long)5L, (long)workbook.getSheet("SheetB").getRows());
        Assert.assertEquals((long)8L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    @Test
    public void test_NoAppendTemplateWithSheet1() throws Exception {
        ValueMetaString vmi = new ValueMetaString("new_row");
        ExcelOutputData data = new ExcelOutputData();
        data.fieldnrs = new int[]{0};
        RowMeta rowMetaToBeReturned = (RowMeta)Mockito.spy((Object)new RowMeta());
        rowMetaToBeReturned.addValueMeta(0, (ValueMetaInterface)vmi);
        data.previousMeta = rowMetaToBeReturned;
        ExcelOutput excelOutput = (ExcelOutput)Mockito.spy((Object)new ExcelOutput(ExcelOutputTest.helper.stepMeta, (StepDataInterface)data, 0, ExcelOutputTest.helper.transMeta, ExcelOutputTest.helper.trans));
        excelOutput.first = false;
        Object[] row = new Object[]{new Date()};
        ((ExcelOutput)Mockito.doReturn((Object)row).when((Object)excelOutput)).getRow();
        ((ExcelOutput)Mockito.doReturn((Object)rowMetaToBeReturned).when((Object)excelOutput)).getInputRowMeta();
        String excelFileFullPath = this.buildFilePath();
        File excelFile = new File(excelFileFullPath);
        excelFile.deleteOnExit();
        URL excelTemplateResource = this.getClass().getResource("excel-template-withSheet1.xls");
        String templateFullPath = excelTemplateResource.getFile();
        ExcelOutputMeta meta = this.createStepMeta(excelFileFullPath, templateFullPath, false);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.init((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        excelOutput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Workbook workbook = Workbook.getWorkbook((File)excelFile);
        Assert.assertEquals((long)3L, (long)workbook.getSheets().length);
        Assert.assertEquals((long)4L, (long)workbook.getSheet("SheetA").getRows());
        Assert.assertEquals((long)5L, (long)workbook.getSheet("SheetB").getRows());
        Assert.assertEquals((long)5L, (long)workbook.getSheet(CREATED_SHEET_NAME).getRows());
    }

    static {
        env = new RestorePDIEngineEnvironment();
    }
}

