/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutput;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ExcelOutputTemplateTest {
    private static StepMockHelper<ExcelOutputMeta, ExcelOutputData> helper;
    @ClassRule
    public static RestorePDIEngineEnvironment env;

    @BeforeClass
    public static void setUp() throws KettleException {
        KettleEnvironment.init();
        helper = new StepMockHelper<ExcelOutputMeta, ExcelOutputData>("ExcelOutputTest", ExcelOutputMeta.class, ExcelOutputData.class);
        Mockito.when((Object)ExcelOutputTemplateTest.helper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)ExcelOutputTemplateTest.helper.logChannelInterface);
        Mockito.when((Object)ExcelOutputTemplateTest.helper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        helper.cleanUp();
    }

    @Test
    public void testExceptionClosingWorkbook() throws Exception {
        ExcelOutput excelOutput = new ExcelOutput(ExcelOutputTemplateTest.helper.stepMeta, ExcelOutputTemplateTest.helper.stepDataInterface, 0, ExcelOutputTemplateTest.helper.transMeta, ExcelOutputTemplateTest.helper.trans);
        ExcelOutputMeta meta = this.createStepMeta();
        excelOutput.init((StepMetaInterface)meta, ExcelOutputTemplateTest.helper.initStepDataInterface);
        Assert.assertEquals((String)"Step init error.", (long)0L, (long)excelOutput.getErrors());
        ((ExcelOutputData)ExcelOutputTemplateTest.helper.initStepDataInterface).formats = new HashMap();
        excelOutput.dispose((StepMetaInterface)meta, ExcelOutputTemplateTest.helper.initStepDataInterface);
        Assert.assertEquals((String)"Step dispose error", (long)0L, (long)excelOutput.getErrors());
    }

    private ExcelOutputMeta createStepMeta() throws IOException {
        File tempFile = File.createTempFile("PDI_tmp", ".tmp");
        tempFile.deleteOnExit();
        ExcelOutputMeta meta = new ExcelOutputMeta();
        meta.setFileName(tempFile.getAbsolutePath());
        meta.setTemplateEnabled(true);
        meta.setTemplateFileName(this.getClass().getResource("chart-template.xls").getFile());
        return meta;
    }

    static {
        env = new RestorePDIEngineEnvironment();
    }
}

