/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class ExcelInputMetaTest {
    LoadSaveTester loadSaveTester;
    ExcelInputMeta meta;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        this.meta = new ExcelInputMeta();
        this.meta.setFileName(new String[]{"1", "2", "3"});
        this.meta.setSheetName(new String[]{"1", "2", "3", "4"});
        this.meta.setField(new ExcelInputField[]{new ExcelInputField("1", 1, 1), new ExcelInputField("2", 2, 2)});
        this.meta.normilizeAllocation();
    }

    @Test
    public void testSerialization() throws KettleException {
        List<String> attributes = Arrays.asList("fileName", "fileMask", "excludeFileMask", "fileRequired", "includeSubFolders", "field", "sheetName", "startRow", "startColumn", "spreadSheetType", "fileField", "sheetField", "sheetRowNumberField", "rowNumberField", "shortFileFieldName", "extensionFieldName", "pathFieldName", "sizeFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("excludeFileMask", "getExludeFileMask");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("pathFieldName", "getPathField");
                this.put("sizeFieldName", "getSizeField");
                this.put("hiddenFieldName", "isHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("pathFieldName", "setPathField");
                this.put("sizeFieldName", "setSizeField");
                this.put("hiddenFieldName", "setIsHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("sheetName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", stringArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("field", new ArrayLoadSaveValidator<ExcelInputField>(new ExcelInputFieldLoadSaveValidator(), 5));
        attrValidatorMap.put("spreadSheetType", new SpreadSheetTypeFieldLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 5));
        this.loadSaveTester = new LoadSaveTester<ExcelInputMeta>(ExcelInputMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testRepoRoundTripWithNullAttr() throws KettleException {
        List<String> attributes = Arrays.asList("fileName", "fileMask", "excludeFileMask", "fileRequired", "includeSubFolders", "field", "sheetName", "startRow", "startColumn", "spreadSheetType", "fileField", "sheetField", "sheetRowNumberField", "rowNumberField", "shortFileFieldName", "extensionFieldName", "pathFieldName", "sizeFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("excludeFileMask", "getExludeFileMask");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("pathFieldName", "getPathField");
                this.put("sizeFieldName", "getSizeField");
                this.put("hiddenFieldName", "isHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("pathFieldName", "setPathField");
                this.put("sizeFieldName", "setSizeField");
                this.put("hiddenFieldName", "setIsHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
            }
        };
        NullStringArrayLoadSaveValidator nullStringArrayLoadSaveValidator = new NullStringArrayLoadSaveValidator();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 1);
        NullNameExcelInputArrayFieldLoadSaveValidator nullNameExcelInputArrayFieldLoadSaveValidator = new NullNameExcelInputArrayFieldLoadSaveValidator();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", nullStringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", stringArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("sheetName", nullStringArrayLoadSaveValidator);
        attrValidatorMap.put("field", nullNameExcelInputArrayFieldLoadSaveValidator);
        attrValidatorMap.put("spreadSheetType", new SpreadSheetTypeFieldLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 1));
        this.loadSaveTester = new LoadSaveTester<ExcelInputMeta>(ExcelInputMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
        this.loadSaveTester.testRepoRoundTrip();
    }

    @Test
    public void testNormilizeAllocation() throws KettleException {
        Assert.assertEquals((long)3L, (long)this.meta.getFileName().length);
        Assert.assertEquals((long)3L, (long)this.meta.getFileMask().length);
        Assert.assertEquals((long)3L, (long)this.meta.getExcludeFileMask().length);
        Assert.assertEquals((long)3L, (long)this.meta.getFileRequired().length);
        Assert.assertEquals((long)3L, (long)this.meta.getIncludeSubFolders().length);
        Assert.assertEquals((long)4L, (long)this.meta.getSheetName().length);
        Assert.assertEquals((long)4L, (long)this.meta.getStartRow().length);
        Assert.assertEquals((long)4L, (long)this.meta.getStartColumn().length);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])this.meta.getFileName());
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3", "4"}, (Object[])this.meta.getSheetName());
        for (String str : this.meta.getFileMask()) {
            Assert.assertEquals(null, (Object)str);
        }
        for (String str : this.meta.getExcludeFileMask()) {
            Assert.assertEquals(null, (Object)str);
        }
        for (String str : this.meta.getFileRequired()) {
            Assert.assertEquals(null, (Object)str);
        }
        for (String str : this.meta.getIncludeSubFolders()) {
            Assert.assertEquals(null, (Object)str);
        }
        for (int itr : this.meta.getStartRow()) {
            Assert.assertEquals((long)0L, (long)itr);
        }
        for (int itr : this.meta.getStartColumn()) {
            Assert.assertEquals((long)0L, (long)itr);
        }
    }

    @Test
    public void testGetXML() throws KettleException {
        Assert.assertEquals((Object)("    <header>N</header>" + SystemUtils.LINE_SEPARATOR + "    <noempty>N</noempty>" + SystemUtils.LINE_SEPARATOR + "    <stoponempty>N</stoponempty>" + SystemUtils.LINE_SEPARATOR + "    <filefield/>" + SystemUtils.LINE_SEPARATOR + "    <sheetfield/>" + SystemUtils.LINE_SEPARATOR + "    <sheetrownumfield/>" + SystemUtils.LINE_SEPARATOR + "    <rownumfield/>" + SystemUtils.LINE_SEPARATOR + "    <sheetfield/>" + SystemUtils.LINE_SEPARATOR + "    <filefield/>" + SystemUtils.LINE_SEPARATOR + "    <limit>0</limit>" + SystemUtils.LINE_SEPARATOR + "    <encoding/>" + SystemUtils.LINE_SEPARATOR + "    <add_to_result_filenames>N</add_to_result_filenames>" + SystemUtils.LINE_SEPARATOR + "    <accept_filenames>N</accept_filenames>" + SystemUtils.LINE_SEPARATOR + "    <accept_field/>" + SystemUtils.LINE_SEPARATOR + "    <accept_stepname/>" + SystemUtils.LINE_SEPARATOR + "    <file>" + SystemUtils.LINE_SEPARATOR + "      <name>1</name>" + SystemUtils.LINE_SEPARATOR + "      <filemask/>" + SystemUtils.LINE_SEPARATOR + "      <exclude_filemask/>" + SystemUtils.LINE_SEPARATOR + "      <file_required/>" + SystemUtils.LINE_SEPARATOR + "      <include_subfolders/>" + SystemUtils.LINE_SEPARATOR + "      <name>2</name>" + SystemUtils.LINE_SEPARATOR + "      <filemask/>" + SystemUtils.LINE_SEPARATOR + "      <exclude_filemask/>" + SystemUtils.LINE_SEPARATOR + "      <file_required/>" + SystemUtils.LINE_SEPARATOR + "      <include_subfolders/>" + SystemUtils.LINE_SEPARATOR + "      <name>3</name>" + SystemUtils.LINE_SEPARATOR + "      <filemask/>" + SystemUtils.LINE_SEPARATOR + "      <exclude_filemask/>" + SystemUtils.LINE_SEPARATOR + "      <file_required/>" + SystemUtils.LINE_SEPARATOR + "      <include_subfolders/>" + SystemUtils.LINE_SEPARATOR + "    </file>" + SystemUtils.LINE_SEPARATOR + "    <fields>" + SystemUtils.LINE_SEPARATOR + "      <field>" + SystemUtils.LINE_SEPARATOR + "        <name>1</name>" + SystemUtils.LINE_SEPARATOR + "        <type>String</type>" + SystemUtils.LINE_SEPARATOR + "        <length>1</length>" + SystemUtils.LINE_SEPARATOR + "        <precision>-1</precision>" + SystemUtils.LINE_SEPARATOR + "        <trim_type>none</trim_type>" + SystemUtils.LINE_SEPARATOR + "        <repeat>N</repeat>" + SystemUtils.LINE_SEPARATOR + "        <format/>" + SystemUtils.LINE_SEPARATOR + "        <currency/>" + SystemUtils.LINE_SEPARATOR + "        <decimal/>" + SystemUtils.LINE_SEPARATOR + "        <group/>" + SystemUtils.LINE_SEPARATOR + "      </field>" + SystemUtils.LINE_SEPARATOR + "      <field>" + SystemUtils.LINE_SEPARATOR + "        <name>2</name>" + SystemUtils.LINE_SEPARATOR + "        <type>String</type>" + SystemUtils.LINE_SEPARATOR + "        <length>2</length>" + SystemUtils.LINE_SEPARATOR + "        <precision>-1</precision>" + SystemUtils.LINE_SEPARATOR + "        <trim_type>none</trim_type>" + SystemUtils.LINE_SEPARATOR + "        <repeat>N</repeat>" + SystemUtils.LINE_SEPARATOR + "        <format/>" + SystemUtils.LINE_SEPARATOR + "        <currency/>" + SystemUtils.LINE_SEPARATOR + "        <decimal/>" + SystemUtils.LINE_SEPARATOR + "        <group/>" + SystemUtils.LINE_SEPARATOR + "      </field>" + SystemUtils.LINE_SEPARATOR + "    </fields>" + SystemUtils.LINE_SEPARATOR + "    <sheets>" + SystemUtils.LINE_SEPARATOR + "      <sheet>" + SystemUtils.LINE_SEPARATOR + "        <name>1</name>" + SystemUtils.LINE_SEPARATOR + "        <startrow>0</startrow>" + SystemUtils.LINE_SEPARATOR + "        <startcol>0</startcol>" + SystemUtils.LINE_SEPARATOR + "        </sheet>" + SystemUtils.LINE_SEPARATOR + "      <sheet>" + SystemUtils.LINE_SEPARATOR + "        <name>2</name>" + SystemUtils.LINE_SEPARATOR + "        <startrow>0</startrow>" + SystemUtils.LINE_SEPARATOR + "        <startcol>0</startcol>" + SystemUtils.LINE_SEPARATOR + "        </sheet>" + SystemUtils.LINE_SEPARATOR + "      <sheet>" + SystemUtils.LINE_SEPARATOR + "        <name>3</name>" + SystemUtils.LINE_SEPARATOR + "        <startrow>0</startrow>" + SystemUtils.LINE_SEPARATOR + "        <startcol>0</startcol>" + SystemUtils.LINE_SEPARATOR + "        </sheet>" + SystemUtils.LINE_SEPARATOR + "      <sheet>" + SystemUtils.LINE_SEPARATOR + "        <name>4</name>" + SystemUtils.LINE_SEPARATOR + "        <startrow>0</startrow>" + SystemUtils.LINE_SEPARATOR + "        <startcol>0</startcol>" + SystemUtils.LINE_SEPARATOR + "        </sheet>" + SystemUtils.LINE_SEPARATOR + "    </sheets>" + SystemUtils.LINE_SEPARATOR + "    <strict_types>N</strict_types>" + SystemUtils.LINE_SEPARATOR + "    <error_ignored>N</error_ignored>" + SystemUtils.LINE_SEPARATOR + "    <error_line_skipped>N</error_line_skipped>" + SystemUtils.LINE_SEPARATOR + "    <bad_line_files_destination_directory/>" + SystemUtils.LINE_SEPARATOR + "    <bad_line_files_extension/>" + SystemUtils.LINE_SEPARATOR + "    <error_line_files_destination_directory/>" + SystemUtils.LINE_SEPARATOR + "    <error_line_files_extension/>" + SystemUtils.LINE_SEPARATOR + "    <line_number_files_destination_directory/>" + SystemUtils.LINE_SEPARATOR + "    <line_number_files_extension/>" + SystemUtils.LINE_SEPARATOR + "    <shortFileFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <pathFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <hiddenFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <lastModificationTimeFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <uriNameFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <rootUriNameFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <extensionFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <sizeFieldName/>" + SystemUtils.LINE_SEPARATOR + "    <spreadsheet_type/>" + SystemUtils.LINE_SEPARATOR + "    <password>Encrypted </password>" + SystemUtils.LINE_SEPARATOR), (Object)this.meta.getXML());
    }

    @Test
    public void testClone() throws KettleException {
        ExcelInputMeta clone = (ExcelInputMeta)this.meta.clone();
        Assert.assertEquals((Object)this.meta.getXML(), (Object)clone.getXML());
    }

    @Test
    public void testPDI16559() throws Exception {
        ExcelInputMeta excelInput = new ExcelInputMeta();
        excelInput.setFileName(new String[]{"file1", "file2", "file3", "file4", "file5"});
        excelInput.setFileMask(new String[]{"mask1", "mask2", "mask3", "mask4"});
        excelInput.setExcludeFileMask(new String[]{"excludeMask1", "excludeMask2", "excludeMask3"});
        excelInput.setIncludeSubFolders(new String[]{"yes", "no"});
        excelInput.setSheetName(new String[]{"sheet1", "sheet2", "sheet3"});
        excelInput.setStartRow(new int[]{0, 15});
        excelInput.setStartColumn(new int[]{9});
        excelInput.afterInjectionSynchronization();
        String ktrXml = excelInput.getXML();
        int targetLen = excelInput.getFileName().length;
        Assert.assertEquals((long)targetLen, (long)excelInput.getFileMask().length);
        Assert.assertEquals((long)targetLen, (long)excelInput.getExcludeFileMask().length);
        Assert.assertEquals((long)targetLen, (long)excelInput.getFileRequired().length);
        Assert.assertEquals((long)targetLen, (long)excelInput.getIncludeSubFolders().length);
        targetLen = excelInput.getSheetName().length;
        Assert.assertEquals((long)targetLen, (long)excelInput.getStartRow().length);
        Assert.assertEquals((long)targetLen, (long)excelInput.getStartColumn().length);
    }

    public class NullNameExcelInputArrayFieldLoadSaveValidator
    implements FieldLoadSaveValidator<ExcelInputField[]> {
        @Override
        public ExcelInputField[] getTestObject() {
            ExcelInputField rtn = new ExcelInputField();
            rtn.setName(null);
            return new ExcelInputField[]{rtn};
        }

        @Override
        public boolean validateTestObject(ExcelInputField[] original, Object actualObject) {
            ExcelInputField[] actual;
            ExcelInputField[] excelInputFieldArray = actual = actualObject instanceof ExcelInputField[] ? (ExcelInputField[])actualObject : null;
            if (actual == null || actual.length != 1 || original.length != 1 || original[0].getName() != null) {
                return false;
            }
            return "".equals(actual[0].getName());
        }
    }

    public class NullStringArrayLoadSaveValidator
    implements FieldLoadSaveValidator<String[]> {
        @Override
        public String[] getTestObject() {
            return new String[]{null};
        }

        @Override
        public boolean validateTestObject(String[] original, Object actualObject) {
            String[] actual;
            String[] stringArray = actual = actualObject instanceof String[] ? (String[])actualObject : null;
            if (actual == null || actual.length != 1 || original.length != 1 || original[0] != null) {
                return false;
            }
            return "".equals(actual[0]);
        }
    }

    public class SpreadSheetTypeFieldLoadSaveValidator
    implements FieldLoadSaveValidator<SpreadSheetType> {
        @Override
        public SpreadSheetType getTestObject() {
            return SpreadSheetType.POI;
        }

        @Override
        public boolean validateTestObject(SpreadSheetType testObject, Object actual) {
            return true;
        }
    }

    public class ExcelInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<ExcelInputField> {
        final Random rand = new Random();

        @Override
        public ExcelInputField getTestObject() {
            ExcelInputField rtn = new ExcelInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setLength(this.rand.nextInt(50));
            rtn.setType(this.rand.nextInt(5) + 1);
            return rtn;
        }

        @Override
        public boolean validateTestObject(ExcelInputField testObject, Object actual) {
            if (!(actual instanceof ExcelInputField)) {
                return false;
            }
            ExcelInputField another = (ExcelInputField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append(testObject.getType(), another.getType()).append(testObject.getLength(), another.getLength()).append((Object)testObject.getFormat(), (Object)another.getFormat()).append(testObject.getTrimType(), another.getTrimType()).append(testObject.getPrecision(), another.getPrecision()).append((Object)testObject.getCurrencySymbol(), (Object)another.getCurrencySymbol()).append((Object)testObject.getDecimalSymbol(), (Object)another.getDecimalSymbol()).append((Object)testObject.getGroupSymbol(), (Object)another.getGroupSymbol()).append(testObject.isRepeated(), another.isRepeated()).isEquals();
        }
    }
}

