/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.Const;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.excelinput.BaseExcelParsingTest;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;

public class ExcelInputContentParsingTest
extends BaseExcelParsingTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String[] CNST_3_SHEET_NAME_ARRAY = new String[]{"Sheet1", "Sheet2", "Sheet3"};
    private static final String[] CNST_1_SHEET_NAME_ARRAY = new String[]{"Sheet1"};
    private static final int[] CNST_3_SHEET_START_ROW_ARRAY = new int[]{23, 3, 7};
    private static final int[] CNST_3_ZERO_INT_ARRAY = new int[]{0, 0, 0};
    private static final int[] CNST_1_ZERO_INT_ARRAY = new int[]{0};
    private static final int PDI_17765_ROW_LIMIT_SINGLE_SHEET = 10;
    private static final int PDI_17765_ROW_LIMIT_MULTIPLE_SHEET = 20;

    @Override
    public void before() {
        super.before();
        System.clearProperty("KETTLE_ZIP_MAX_ENTRY_SIZE");
        System.clearProperty("KETTLE_ZIP_MAX_TEXT_SIZE");
        System.clearProperty("KETTLE_ZIP_MIN_INFLATE_RATIO");
    }

    @Test
    public void testXLS() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.JXL);
        this.init("sample.xls");
        this.setFields(new ExcelInputField("f1", -1, -1), new ExcelInputField("f2", -1, -1));
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testXLSX() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.POI);
        this.init("sample.xlsx");
        this.setFields(new ExcelInputField("f1", -1, -1), new ExcelInputField("f2", -1, -1));
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testXLSXStream() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.init("sample.xlsx");
        this.setFields(new ExcelInputField("f1", -1, -1), new ExcelInputField("f2", -1, -1));
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testODS24() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.ODS);
        this.init("sample-2.4.ods");
        this.setFields(new ExcelInputField("f1", -1, -1), new ExcelInputField("f2", -1, -1));
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testODS341() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.ODS);
        this.init("sample-3.4.1.ods");
        this.setFields(new ExcelInputField("f1", -1, -1), new ExcelInputField("f2", -1, -1));
        this.process();
        this.check(new Object[][]{{"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}});
    }

    @Test
    public void testZipBombConfiguration_Default() throws Exception {
        Long bogusMaxEntrySize = 1000L;
        ZipSecureFile.setMaxEntrySize((long)bogusMaxEntrySize);
        Long bogusMaxTextSize = 1000L;
        ZipSecureFile.setMaxTextSize((long)bogusMaxTextSize);
        Double bogusMinInflateRatio = 0.5;
        ZipSecureFile.setMinInflateRatio((double)bogusMinInflateRatio);
        Assert.assertEquals((Object)bogusMaxEntrySize, (Object)ZipSecureFile.getMaxEntrySize());
        Assert.assertEquals((Object)bogusMaxTextSize, (Object)ZipSecureFile.getMaxTextSize());
        Assert.assertEquals((Object)bogusMinInflateRatio, (Object)ZipSecureFile.getMinInflateRatio());
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.init("Balance_Type_Codes.xlsx");
        Assert.assertEquals((Object)Const.KETTLE_ZIP_MAX_ENTRY_SIZE_DEFAULT, (Object)ZipSecureFile.getMaxEntrySize());
        Assert.assertEquals((Object)Const.KETTLE_ZIP_MAX_TEXT_SIZE_DEFAULT, (Object)ZipSecureFile.getMaxTextSize());
        Assert.assertEquals((Object)Const.KETTLE_ZIP_MIN_INFLATE_RATIO_DEFAULT, (Object)ZipSecureFile.getMinInflateRatio());
    }

    @Test
    public void testZipBombConfiguration() throws Exception {
        Long maxEntrySizeVal = 0xC0000000L;
        Long maxTextSizeVal = 0x80000000L;
        Double minInflateRatioVal = 0.123;
        System.setProperty("KETTLE_ZIP_MAX_ENTRY_SIZE", maxEntrySizeVal.toString());
        System.setProperty("KETTLE_ZIP_MAX_TEXT_SIZE", maxTextSizeVal.toString());
        System.setProperty("KETTLE_ZIP_MIN_INFLATE_RATIO", minInflateRatioVal.toString());
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.init("Balance_Type_Codes.xlsx");
        Assert.assertEquals((Object)maxEntrySizeVal, (Object)ZipSecureFile.getMaxEntrySize());
        Assert.assertEquals((Object)maxTextSizeVal, (Object)ZipSecureFile.getMaxTextSize());
        Assert.assertEquals((Object)minInflateRatioVal, (Object)ZipSecureFile.getMinInflateRatio());
    }

    @Test
    public void testXLSXCompressionRatioIsBig() throws Exception {
        Double minInflateRatio = 0.007;
        System.setProperty("KETTLE_ZIP_MIN_INFLATE_RATIO", minInflateRatio.toString());
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.init("Balance_Type_Codes.xlsx");
        Assert.assertEquals((Object)minInflateRatio, (Object)ZipSecureFile.getMinInflateRatio());
        this.setFields(new ExcelInputField("FIST ID", -1, -1), new ExcelInputField("SOURCE SYSTEM", -1, -1));
        this.process();
        this.checkErrors();
        this.checkContent(new Object[][]{{"FIST0200", "ACM"}});
    }

    protected void test_PDI_17765(int rowLimit, boolean startsWithHeader, int[] startRowArr, int[] startColumnArr, String[] sheetNameArr) throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.setFields(new ExcelInputField("COL", -1, -1));
        ((ExcelInputMeta)this.meta).setRowLimit((long)rowLimit);
        ((ExcelInputMeta)this.meta).setStartsWithHeader(startsWithHeader);
        ((ExcelInputMeta)this.meta).setStartRow(startRowArr);
        ((ExcelInputMeta)this.meta).setStartColumn(startColumnArr);
        ((ExcelInputMeta)this.meta).setSheetName(sheetNameArr);
        ((ExcelInputMeta)this.meta).normilizeAllocation();
        this.init("pdi-17765.xlsx");
        this.process();
        this.checkErrors();
        Assert.assertEquals((String)"Wrong row count", (long)rowLimit, (long)this.rows.size());
    }

    protected void test_PDI_17765_SingleSheet(int rowLimit, boolean startsWithHeader, int startRow, Object firstResult, Object lastResult) throws Exception {
        this.test_PDI_17765(10, startsWithHeader, new int[]{startRow}, CNST_1_ZERO_INT_ARRAY, CNST_1_SHEET_NAME_ARRAY);
        Assert.assertEquals((String)"Wrong row count", (long)10L, (long)this.rows.size());
        Assert.assertEquals((String)"Wrong first result", (Object)firstResult, (Object)((Object[])this.rows.get(0))[0]);
        Assert.assertEquals((String)"Wrong last result", (Object)lastResult, (Object)((Object[])this.rows.get(9))[0]);
    }

    @Test
    public void test_PDI_17765_SingleSheet_Header_StartRow0() throws Exception {
        String firstResult = "1.0";
        String lastResult = "10.0";
        this.test_PDI_17765_SingleSheet(10, true, 0, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_SingleSheet_NoHeader_StartRow0() throws Exception {
        String firstResult = "col";
        String lastResult = "9.0";
        this.test_PDI_17765_SingleSheet(10, false, 0, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_SingleSheet_Header_StartRow5() throws Exception {
        String firstResult = "6.0";
        String lastResult = "15.0";
        this.test_PDI_17765_SingleSheet(10, true, 5, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_SingleSheet_NoHeader_StartRow5() throws Exception {
        String firstResult = "5.0";
        String lastResult = "14.0";
        this.test_PDI_17765_SingleSheet(10, false, 5, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_SingleSheet_Header_StartRow12() throws Exception {
        String firstResult = "13.0";
        String lastResult = "22.0";
        this.test_PDI_17765_SingleSheet(10, true, 12, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_SingleSheet_NoHeader_StartRow12() throws Exception {
        String firstResult = "12.0";
        String lastResult = "21.0";
        this.test_PDI_17765_SingleSheet(10, false, 12, firstResult, lastResult);
    }

    @Test
    public void test_PDI_17765_MultipleSheets_Header_StartRow0() throws Exception {
        String firstResult = "1.0";
        String lastResult = "20.0";
        this.test_PDI_17765(20, true, CNST_3_ZERO_INT_ARRAY, CNST_3_ZERO_INT_ARRAY, CNST_3_SHEET_NAME_ARRAY);
        Assert.assertEquals((String)"Wrong first result", (Object)firstResult, (Object)((Object[])this.rows.get(0))[0]);
        Assert.assertEquals((String)"Wrong last result", (Object)lastResult, (Object)((Object[])this.rows.get(19))[0]);
    }

    @Test
    public void test_PDI_17765_MultipleSheets_NoHeader_StartRow0() throws Exception {
        String firstResult = "col";
        String lastResult = "19.0";
        this.test_PDI_17765(20, false, CNST_3_ZERO_INT_ARRAY, CNST_3_ZERO_INT_ARRAY, CNST_3_SHEET_NAME_ARRAY);
        Assert.assertEquals((String)"Wrong first result", (Object)firstResult, (Object)((Object[])this.rows.get(0))[0]);
        Assert.assertEquals((String)"Wrong last result", (Object)lastResult, (Object)((Object[])this.rows.get(19))[0]);
    }

    @Test
    public void test_PDI_17765_MultipleSheets_Header_StartRowX() throws Exception {
        String firstResult = "24.0";
        String lastResult = "132.0";
        this.test_PDI_17765(20, true, CNST_3_SHEET_START_ROW_ARRAY, CNST_3_ZERO_INT_ARRAY, CNST_3_SHEET_NAME_ARRAY);
        Assert.assertEquals((String)"Wrong first result", (Object)firstResult, (Object)((Object[])this.rows.get(0))[0]);
        Assert.assertEquals((String)"Wrong last result", (Object)lastResult, (Object)((Object[])this.rows.get(19))[0]);
    }

    @Test
    public void test_PDI_17765_MultipleSheets_NoHeader_StartRowX() throws Exception {
        String firstResult = "23.0";
        String lastResult = "102.0";
        this.test_PDI_17765(20, false, CNST_3_SHEET_START_ROW_ARRAY, CNST_3_ZERO_INT_ARRAY, CNST_3_SHEET_NAME_ARRAY);
        Assert.assertEquals((String)"Wrong first result", (Object)firstResult, (Object)((Object[])this.rows.get(0))[0]);
        Assert.assertEquals((String)"Wrong last result", (Object)lastResult, (Object)((Object[])this.rows.get(19))[0]);
    }
}

