/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dummytrans;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTrans;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class DummyTransTest {
    private StepMockHelper<StepMetaInterface, StepDataInterface> stepMockHelper;

    @Before
    public void setup() {
        this.stepMockHelper = new StepMockHelper<StepMetaInterface, StepDataInterface>("DUMMY TEST", StepMetaInterface.class, StepDataInterface.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testDummyTransDoesntWriteOutputWithoutInputRow() throws KettleException {
        DummyTrans dummy = new DummyTrans(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        dummy.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        RowSet rowSet = this.stepMockHelper.getMockInputRowSet(new Object[0][]);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        dummy.addRowSetToInputRowSets(rowSet);
        RowSet outputRowSet = (RowSet)Mockito.mock(RowSet.class);
        dummy.addRowSetToOutputRowSets(outputRowSet);
        dummy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface);
        ((RowMetaInterface)Mockito.verify((Object)inputRowMeta, (VerificationMode)Mockito.never())).cloneRow((Object[])Matchers.any(Object[].class));
        ((RowSet)Mockito.verify((Object)outputRowSet, (VerificationMode)Mockito.never())).putRow((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class));
    }

    @Test
    public void testDummyTransWritesOutputWithInputRow() throws KettleException {
        DummyTrans dummy = new DummyTrans(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        dummy.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        Object[] row = new Object[]{"abcd"};
        RowSet rowSet = this.stepMockHelper.getMockInputRowSet(new Object[][]{row});
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        dummy.addRowSetToInputRowSets(rowSet);
        RowSet outputRowSet = (RowSet)Mockito.mock(RowSet.class);
        dummy.addRowSetToOutputRowSets(outputRowSet);
        Mockito.when((Object)outputRowSet.putRow(inputRowMeta, row)).thenReturn((Object)true);
        dummy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface);
        ((RowSet)Mockito.verify((Object)outputRowSet, (VerificationMode)Mockito.times((int)1))).putRow(inputRowMeta, row);
    }
}

