/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupData;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.NonZeroIntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.metastore.api.IMetaStore;

public class DimensionLookupMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<DimensionLookupMeta> testMetaClass = DimensionLookupMeta.class;
    private ThreadLocal<DimensionLookupMeta> holdTestingMeta = new ThreadLocal();
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    public static final String databaseXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>lookup</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>";

    @BeforeClass
    public static void setupClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUpLoadSave() throws Exception {
        List<String> attributes = Arrays.asList("schemaName", "tableName", "update", "dateField", "dateFrom", "dateTo", "keyField", "keyRename", "autoIncrement", "versionField", "commitSize", "useBatchUpdate", "minYear", "maxYear", "techKeyCreation", "cacheSize", "usingStartDateAlternative", "startDateAlternative", "startDateFieldName", "preloadingCache", "keyStream", "keyLookup", "fieldStream", "fieldLookup", "fieldUpdate", "databaseMeta", "sequenceName");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("useBatchUpdate", "useBatchUpdate");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keyStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldUpdate", new FieldUpdateIntArrayLoadSaveValidator(new NonZeroIntLoadSaveValidator(DimensionLookupMeta.typeDesc.length), 5));
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        attrValidatorMap.put("startDateAlternative", new IntLoadSaveValidator(DimensionLookupMeta.getStartDateAlternativeCodes().length));
        attrValidatorMap.put("sequenceName", new SequenceNameLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof DimensionLookupMeta) {
            ((DimensionLookupMeta)someMeta).allocate(5, 5);
            this.holdTestingMeta.set((DimensionLookupMeta)someMeta);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Before
    public void setUp() throws Exception {
        LogChannelInterfaceFactory logChannelInterfaceFactory = (LogChannelInterfaceFactory)Mockito.mock(LogChannelInterfaceFactory.class);
        LogChannelInterface logChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)logChannelInterfaceFactory);
        Mockito.when((Object)logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)logChannelInterface);
    }

    @Test
    public void testGetFields() throws Exception {
        RowMeta extraFields = new RowMeta();
        extraFields.addValueMeta((ValueMetaInterface)new ValueMetaString("field1"));
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        DimensionLookupMeta meta = (DimensionLookupMeta)Mockito.spy((Object)new DimensionLookupMeta());
        meta.setUpdate(false);
        meta.setKeyField(null);
        meta.setFieldLookup(new String[]{"field1"});
        meta.setFieldStream(new String[]{""});
        meta.setDatabaseMeta(dbMeta);
        ((DimensionLookupMeta)Mockito.doReturn((Object)extraFields).when((Object)meta)).getDatabaseTableFields((Database)Matchers.anyObject(), Matchers.anyString(), Matchers.anyString());
        ((DimensionLookupMeta)Mockito.doReturn((Object)Mockito.mock(LogChannelInterface.class)).when((Object)meta)).getLog();
        RowMeta row = new RowMeta();
        try {
            meta.getFields((RowMetaInterface)row, "DimensionLookupMetaTest", (RowMetaInterface[])new RowMeta[]{row}, null, null, null, null);
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains(BaseMessages.getString(DimensionLookupMeta.class, (String)"DimensionLookupMeta.Error.NoTechnicalKeySpecified", (String[])new String[0])));
        }
    }

    @Test
    public void testUseDefaultSchemaName() throws Exception {
        String schemaName = "";
        String tableName = "tableName";
        String schemaTable = "default.tableName";
        String keyField = "keyField";
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.spy((Object)new DatabaseMeta(databaseXML){

            public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc) {
                return "someValue";
            }
        });
        Mockito.when((Object)databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName)).thenReturn((Object)schemaTable);
        DimensionLookupMeta dlm = new DimensionLookupMeta();
        dlm.setUpdate(true);
        dlm.setDatabaseMeta(databaseMeta);
        dlm.setTableName(tableName);
        dlm.setSchemaName(schemaName);
        dlm.setKeyLookup(new String[]{"keyLookup1", "keyLookup2"});
        dlm.setKeyStream(new String[]{"keyStream1", "keyStream2"});
        dlm.setFieldLookup(new String[]{"fieldLookup1", "fieldLookup2"});
        dlm.setFieldStream(new String[]{"FieldStream1", "FieldStream2"});
        dlm.setFieldUpdate(new int[]{1, 2});
        dlm.setKeyField(keyField);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rowMetaInterface.size()).thenReturn((Object)1);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        SQLStatement sqlStatement = dlm.getSQLStatements(new TransMeta(), stepMeta, rowMetaInterface, repository, metaStore);
        String sql = sqlStatement.getSQL();
        Assert.assertEquals((long)3L, (long)StringUtils.countMatches((String)sql, (String)schemaTable));
    }

    @Test
    public void testProvidesModelerMeta() throws Exception {
        final RowMeta rowMeta = (RowMeta)Mockito.mock(RowMeta.class);
        DimensionLookupMeta dimensionLookupMeta = new DimensionLookupMeta(){

            Database createDatabaseObject() {
                return (Database)Mockito.mock(Database.class);
            }

            protected RowMetaInterface getDatabaseTableFields(Database db, String schemaName, String tableName) throws KettleDatabaseException {
                Assert.assertEquals((Object)"aSchema", (Object)schemaName);
                Assert.assertEquals((Object)"aDimTable", (Object)tableName);
                return rowMeta;
            }
        };
        dimensionLookupMeta.setFieldLookup(new String[]{"f1", "f2", "f3"});
        dimensionLookupMeta.setKeyLookup(new String[]{"k1"});
        dimensionLookupMeta.setFieldStream(new String[]{"s4", "s5", "s6"});
        dimensionLookupMeta.setKeyStream(new String[]{"ks1"});
        dimensionLookupMeta.setSchemaName("aSchema");
        dimensionLookupMeta.setTableName("aDimTable");
        DimensionLookupData dimensionLookupData = new DimensionLookupData();
        Assert.assertEquals((Object)rowMeta, (Object)dimensionLookupMeta.getRowMeta((StepDataInterface)dimensionLookupData));
        Assert.assertEquals((long)4L, (long)dimensionLookupMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", dimensionLookupMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", dimensionLookupMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", dimensionLookupMeta.getDatabaseFields().get(2));
        Assert.assertEquals((Object)"k1", dimensionLookupMeta.getDatabaseFields().get(3));
        Assert.assertEquals((long)4L, (long)dimensionLookupMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", dimensionLookupMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", dimensionLookupMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", dimensionLookupMeta.getStreamFields().get(2));
        Assert.assertEquals((Object)"ks1", dimensionLookupMeta.getStreamFields().get(3));
    }

    @Test
    public void testPDI16559() throws Exception {
        DimensionLookupMeta dimensionLookup = new DimensionLookupMeta();
        dimensionLookup.setKeyStream(new String[]{"test_field"});
        dimensionLookup.setKeyLookup(new String[0]);
        dimensionLookup.setCacheSize(15);
        dimensionLookup.setSchemaName("test_schema");
        dimensionLookup.setFieldStream(new String[]{"123", "abc", "def"});
        dimensionLookup.setFieldLookup(new String[]{"wibble"});
        dimensionLookup.setFieldUpdate(new int[]{11, 12});
        try {
            String badXml = dimensionLookup.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        dimensionLookup.afterInjectionSynchronization();
        String ktrXml = dimensionLookup.getXML();
        Assert.assertEquals((long)dimensionLookup.getKeyStream().length, (long)dimensionLookup.getKeyLookup().length);
        Assert.assertEquals((long)dimensionLookup.getFieldStream().length, (long)dimensionLookup.getFieldLookup().length);
        Assert.assertEquals((long)dimensionLookup.getFieldUpdate().length, (long)dimensionLookup.getFieldUpdate().length);
    }

    public class FieldUpdateIntArrayLoadSaveValidator
    extends PrimitiveIntArrayLoadSaveValidator {
        public FieldUpdateIntArrayLoadSaveValidator(FieldLoadSaveValidator<Integer> fieldValidator) {
            this(fieldValidator, null);
        }

        public FieldUpdateIntArrayLoadSaveValidator(FieldLoadSaveValidator<Integer> fieldValidator, Integer elements) {
            super(fieldValidator, elements);
        }

        @Override
        public int[] getTestObject() {
            DimensionLookupMeta dlm = (DimensionLookupMeta)DimensionLookupMetaTest.this.holdTestingMeta.get();
            int[] testObject = super.getTestObject();
            if (!dlm.isUpdate()) {
                dlm.setReturnType(testObject);
            }
            return testObject;
        }
    }

    public class SequenceNameLoadSaveValidator
    implements FieldLoadSaveValidator<String> {
        final Random rand = new Random();

        @Override
        public String getTestObject() {
            DimensionLookupMeta dlm = (DimensionLookupMeta)DimensionLookupMetaTest.this.holdTestingMeta.get();
            if (dlm.isUpdate()) {
                return UUID.randomUUID().toString();
            }
            return null;
        }

        @Override
        public boolean validateTestObject(String testObject, Object actual) {
            String another = (String)actual;
            DimensionLookupMeta dlm = (DimensionLookupMeta)DimensionLookupMetaTest.this.holdTestingMeta.get();
            if (dlm.isUpdate()) {
                return testObject.equals(another);
            }
            return another == null;
        }
    }
}

