/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.detectlastrow;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.detectlastrow.DetectLastRowData;
import org.pentaho.di.trans.steps.detectlastrow.DetectLastRowMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;

public class DetectLastRowMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testStepMeta() throws KettleException {
        List<String> attributes = Arrays.asList("ResultFieldName");
        LoadSaveTester<DetectLastRowMeta> loadSaveTester = new LoadSaveTester<DetectLastRowMeta>(DetectLastRowMeta.class, attributes);
        loadSaveTester.testSerialization();
    }

    @Test
    public void testDefault() {
        DetectLastRowMeta meta = new DetectLastRowMeta();
        meta.setDefault();
        Assert.assertEquals((Object)"result", (Object)meta.getResultFieldName());
    }

    @Test
    public void testGetData() {
        DetectLastRowMeta meta = new DetectLastRowMeta();
        Assert.assertTrue((boolean)(meta.getStepData() instanceof DetectLastRowData));
    }

    @Test
    public void testGetFields() throws KettleStepException {
        DetectLastRowMeta meta = new DetectLastRowMeta();
        meta.setDefault();
        meta.setResultFieldName("The Result");
        RowMeta rowMeta = new RowMeta();
        meta.getFields((RowMetaInterface)rowMeta, "this step", null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertEquals((long)1L, (long)rowMeta.size());
        Assert.assertEquals((Object)"The Result", (Object)rowMeta.getValueMeta(0).getName());
        Assert.assertEquals((long)4L, (long)rowMeta.getValueMeta(0).getType());
    }

    @Test
    public void testSupportedTransformationTypes() {
        DetectLastRowMeta meta = new DetectLastRowMeta();
        Assert.assertEquals((long)1L, (long)meta.getSupportedTransformationTypes().length);
        Assert.assertEquals((Object)TransMeta.TransformationType.Normal, (Object)meta.getSupportedTransformationTypes()[0]);
    }
}

