/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.denormaliser;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.denormaliser.Denormaliser;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserData;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMeta;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class PDI4910_DenormaliserTest {
    private StepMockHelper<DenormaliserMeta, DenormaliserData> mockHelper;
    private Denormaliser denormaliser;

    @Before
    public void init() {
        this.mockHelper = new StepMockHelper<DenormaliserMeta, DenormaliserData>("Denormalizer", DenormaliserMeta.class, DenormaliserData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testDeNormalise() throws Exception {
        DenormaliserData stepData = new DenormaliserData();
        stepData.keyFieldNr = 0;
        stepData.keyValue = new HashMap();
        stepData.keyValue.put("1", Arrays.asList(0, 1));
        stepData.fieldNameIndex = new int[]{1, 2};
        stepData.inputRowMeta = new RowMeta();
        ValueMetaDate outDateField1 = new ValueMetaDate("date_field[yyyy-MM-dd]");
        ValueMetaDate outDateField2 = new ValueMetaDate("date_field[yyyy/MM/dd]");
        stepData.outputRowMeta = new RowMeta();
        stepData.outputRowMeta.addValueMeta(0, (ValueMetaInterface)outDateField1);
        stepData.outputRowMeta.addValueMeta(1, (ValueMetaInterface)outDateField2);
        stepData.removeNrs = new int[0];
        stepData.targetResult = new Object[]{null, null};
        DenormaliserMeta stepMeta = new DenormaliserMeta();
        DenormaliserTargetField[] denormaliserTargetFields = new DenormaliserTargetField[2];
        DenormaliserTargetField targetField1 = new DenormaliserTargetField();
        DenormaliserTargetField targetField2 = new DenormaliserTargetField();
        targetField1.setTargetFormat("yyyy-MM-dd");
        targetField2.setTargetFormat("yyyy/MM/dd");
        denormaliserTargetFields[0] = targetField1;
        denormaliserTargetFields[1] = targetField2;
        stepMeta.setDenormaliserTargetField(denormaliserTargetFields);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta(0, (ValueMetaInterface)new ValueMetaInteger("key"));
        rowMeta.addValueMeta(1, (ValueMetaInterface)new ValueMetaString("stringDate1"));
        rowMeta.addValueMeta(2, (ValueMetaInterface)new ValueMetaString("stringDate2"));
        Object[] rowData = new Object[]{1L, "2000-10-20", "2000/10/20"};
        this.denormaliser = new Denormaliser(this.mockHelper.stepMeta, (StepDataInterface)stepData, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        Field metaField = this.denormaliser.getClass().getDeclaredField("meta");
        Assert.assertNotNull((String)"Can't find a field 'meta' in class Denormalizer", (Object)metaField);
        metaField.setAccessible(true);
        metaField.set(this.denormaliser, stepMeta);
        Method deNormalise = this.denormaliser.getClass().getDeclaredMethod("deNormalise", RowMetaInterface.class, Object[].class);
        Assert.assertNotNull((String)"Can't find a method 'deNormalise' in class Denormalizer", (Object)deNormalise);
        deNormalise.setAccessible(true);
        deNormalise.invoke((Object)this.denormaliser, rowMeta, rowData);
        for (Object res : stepData.targetResult) {
            Assert.assertNotNull((String)"Date is null", (Object)res);
        }
    }
}

