/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.denormaliser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.denormaliser.Denormaliser;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserData;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMeta;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class DenormaliserAggregationsTest {
    static final String JUNIT = "JUNIT";
    static StepMockHelper<DenormaliserMeta, DenormaliserData> mockHelper;
    Denormaliser step;
    DenormaliserData data = new DenormaliserData();
    DenormaliserMeta meta = new DenormaliserMeta();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<DenormaliserMeta, DenormaliserData>("Denormaliser", DenormaliserMeta.class, DenormaliserData.class);
        Mockito.when((Object)DenormaliserAggregationsTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)DenormaliserAggregationsTest.mockHelper.logChannelInterface);
        Mockito.when((Object)DenormaliserAggregationsTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        mockHelper.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)DenormaliserAggregationsTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)this.meta);
        this.step = new Denormaliser(DenormaliserAggregationsTest.mockHelper.stepMeta, (StepDataInterface)this.data, 0, DenormaliserAggregationsTest.mockHelper.transMeta, DenormaliserAggregationsTest.mockHelper.trans);
    }

    @Test
    public void testDenormalizeSum100PlusNull() throws KettleValueException {
        Long sto = new Long(100L);
        this.data.targetResult = new Object[]{sto};
        this.step.deNormalise(this.testSumPreconditions("SUM"), new Object[]{JUNIT, null});
        Assert.assertEquals((String)"100 + null = 100 ", (Object)sto, (Object)this.data.targetResult[0]);
    }

    @Test
    public void testDenormalizeSumNullPlus100() throws KettleValueException {
        Long sto = new Long(100L);
        this.data.targetResult = new Object[]{null};
        this.step.deNormalise(this.testSumPreconditions("SUM"), new Object[]{JUNIT, sto});
        Assert.assertEquals((String)"null + 100 = 100 ", (Object)sto, (Object)this.data.targetResult[0]);
    }

    @Test
    public void testDenormalizeMinValueY() throws KettleValueException {
        this.step.setMinNullIsValued(true);
        Long trinadzat = new Long(-13L);
        this.data.targetResult = new Object[]{trinadzat};
        this.step.deNormalise(this.testSumPreconditions("MIN"), new Object[]{JUNIT, null});
        Assert.assertNull((String)"Null now is new minimal", (Object)this.data.targetResult[0]);
    }

    @Test
    public void testDenormalizeMinValueN() throws KettleValueException {
        this.step.setVariable("KETTLE_AGGREGATION_MIN_NULL_IS_VALUED", "N");
        Long sto = new Long(100L);
        this.data.targetResult = new Object[]{sto};
        this.step.deNormalise(this.testSumPreconditions("MIN"), new Object[]{JUNIT, null});
        Assert.assertEquals((String)"Null is ignored", (Object)sto, (Object)this.data.targetResult[0]);
    }

    RowMetaInterface testSumPreconditions(String agg) {
        RowMeta rmi = new RowMeta();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new ValueMetaString("a"));
        list.add(new ValueMetaInteger("b"));
        list.add(new ValueMetaInteger("d"));
        rmi.setValueMetaList(list);
        this.data.keyValue = new HashMap();
        ArrayList<Integer> listInt = new ArrayList<Integer>();
        listInt.add(0);
        this.data.keyValue.put(JUNIT, listInt);
        this.data.fieldNameIndex = new int[]{1};
        this.data.inputRowMeta = rmi;
        this.data.outputRowMeta = rmi;
        this.data.removeNrs = new int[]{-1};
        DenormaliserTargetField tField = new DenormaliserTargetField();
        tField.setTargetAggregationType(agg);
        DenormaliserTargetField[] pivotField = new DenormaliserTargetField[]{tField};
        this.meta.setDenormaliserTargetField(pivotField);
        return rmi;
    }

    @Test
    public void testBuildResultWithNullsY() throws KettleValueException {
        this.step.setAllNullsAreZero(true);
        Object[] rowData = new Object[10];
        this.data.targetResult = new Object[1];
        RowMetaInterface rmi = this.testSumPreconditions("-");
        this.data.removeNrs = new int[]{0};
        Object[] outputRowData = this.step.buildResult(rmi, rowData);
        Assert.assertEquals((String)"Output row: nulls are zeros", (Object)new Long(0L), (Object)outputRowData[2]);
    }

    @Test
    public void testBuildResultWithNullsN() throws KettleValueException {
        this.step.setAllNullsAreZero(false);
        Object[] rowData = new Object[10];
        this.data.targetResult = new Object[1];
        Object[] outputRowData = this.step.buildResult(this.testSumPreconditions("-"), rowData);
        Assert.assertNull((String)"Output row: nulls are nulls", (Object)outputRowData[3]);
    }

    @Test
    public void testNewGroup() throws Exception {
        DenormaliserTargetField field1 = new DenormaliserTargetField();
        field1.setTargetAggregationType("MIN");
        DenormaliserTargetField field2 = new DenormaliserTargetField();
        field2.setTargetAggregationType("MIN");
        DenormaliserTargetField field3 = new DenormaliserTargetField();
        field3.setTargetAggregationType("MIN");
        DenormaliserTargetField[] pivotField = new DenormaliserTargetField[]{field1, field2, field3};
        this.meta.setDenormaliserTargetField(pivotField);
        this.data.counters = new long[3];
        this.data.sum = new Object[3];
        Method newGroupMethod = this.step.getClass().getDeclaredMethod("newGroup", new Class[0]);
        newGroupMethod.setAccessible(true);
        newGroupMethod.invoke((Object)this.step, new Object[0]);
        Assert.assertEquals((long)3L, (long)this.data.targetResult.length);
        for (Object result : this.data.targetResult) {
            Assert.assertNull((Object)result);
        }
    }
}

