/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delete.Delete;
import org.pentaho.di.trans.steps.delete.DeleteData;
import org.pentaho.di.trans.steps.delete.DeleteMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class DeleteMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<DeleteMeta> testMetaClass = DeleteMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMeta stepMeta;
    private Delete del;
    private DeleteData dd;
    private DeleteMeta dmi;

    @Before
    public void setUpLoadSave() throws Exception {
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("schemaName", "tableName", "commitSize", "databaseMeta", "keyStream", "keyLookup", "keyCondition", "keyStream2");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keyStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyCondition", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyStream2", stringArrayLoadSaveValidator);
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof DeleteMeta) {
            ((DeleteMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.dmi = new DeleteMeta();
        this.dd = new DeleteData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.dmi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.dmi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.del = new Delete(this.stepMeta, (StepDataInterface)this.dd, 1, transMeta, trans);
        this.del.copyVariablesFrom((VariableSpace)transMeta);
    }

    @Test
    public void testCommitCountFixed() {
        this.dmi.setCommitSize("100");
        Assert.assertTrue((this.dmi.getCommitSize((VariableSpace)this.del) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.dmi.setCommitSize("${max.sz}");
        Assert.assertTrue((this.dmi.getCommitSize((VariableSpace)this.del) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountMissedVar() {
        this.dmi.setCommitSize("missed-var");
        try {
            this.dmi.getCommitSize((VariableSpace)this.del);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

