/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.datagrid;

import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.datagrid.DataGrid;
import org.pentaho.di.trans.steps.datagrid.DataGridData;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class DataGrid_EmptyStringVsNull_Test {
    private StepMockHelper<DataGridMeta, StepDataInterface> helper;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.helper = StepMockUtil.getStepMockHelper(DataGridMeta.class, "DataGrid_EmptyStringVsNull_Test");
    }

    @After
    public void cleanUp() {
        this.helper.cleanUp();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N");
        List<Object[]> expected = Arrays.asList({"", "", null}, {null, "", null}, {null, "", null});
        this.executeAndAssertResults(expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "Y");
        List<Object[]> expected = Arrays.asList({"", "", null}, {"", "", null}, {"", "", null});
        this.executeAndAssertResults(expected);
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        String stringType = ValueMetaFactory.getValueMetaName((int)2);
        String numberType = ValueMetaFactory.getValueMetaName((int)1);
        DataGridMeta meta = new DataGridMeta();
        meta.allocate(3);
        meta.setFieldName(new String[]{"string", "string-setEmpty", "number"});
        meta.setFieldType(new String[]{stringType, stringType, numberType});
        meta.setEmptyString(new boolean[]{false, true, false});
        List<List> dataRows = Arrays.asList(Arrays.asList(" ", " ", " "), Arrays.asList("", "", ""), Arrays.asList(null, null, null));
        meta.setDataLines(dataRows);
        DataGridData data = new DataGridData();
        DataGrid step = this.createAndInitStep(meta, data);
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, true);
        TransTestingUtil.assertResult(expected, actual);
    }

    private DataGrid createAndInitStep(DataGridMeta meta, DataGridData data) {
        Mockito.when((Object)this.helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        DataGrid step = new DataGrid(this.helper.stepMeta, (StepDataInterface)data, 0, this.helper.transMeta, this.helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

